/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.rules.CPartnerActivityValidator;

public class ReplyValidator
extends CPartnerActivityValidator {
    protected INode fPartnerRoleNode;
    protected INode fVariable;
    protected INode fPortTypeFromRole;
    protected String fVariableName;
    INode fOutMessage;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_TO_PARTS, 0, 1);
    }

    @Override
    protected void start() {
        super.start();
        this.fVariableName = this.getAttribute(this.mNode, AT_VARIABLE, 1, Filters.NC_NAME, false);
        this.fVariable = this.mModelQuery.lookup(this.mNode, 1, this.fVariableName);
        this.fPartnerLinkType = null;
        this.fPartnerRoleNode = null;
    }

    @ARule(sa=2003, desc="Check if outputVariable is set and exists and is defined correctly.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckVariable_3() {
        this.fVariable = this.verifyVariable(this.fVariable, AT_VARIABLE);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if partner role is defined in reply activity.", errors="BPELC_MISSING_ROLE")
    public void rule_CheckIfPartnerRoleIsDefined_5() {
        this.fPartnerRoleNode = this.lookupRoleNode(this.fPartnerLinkNode, AT_PARTNER_ROLE);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks portType and derived portType values on reply activity.", sa=5, errors="BPELC_MISMATCH_ROLE_PORT_TYPE")
    public void rule_CheckRolePortTypeWithReceivePortType_10() {
        this.fPortTypeFromRole = this.verifyPortTypeFromRole(this.fPartnerRoleNode, AT_PARTNER_ROLE, this.fPortType);
    }

    @ARule(author="michal.chmielewski@oracle.com", date="9/25/2006", desc="Checks if output message is defined for reply activity.", errors="BPELC_PA__NO_MESSAGE,BPELC_PA__MSG_TYPE")
    public void rule_CheckOutputMessage_12() {
        this.fOutMessage = this.findMessageType(this.fPortTypeFromRole, this.fOperation, WSDL_ND_OUTPUT, true);
        this.setValue("input.message.type", this.fOutMessage);
    }

    @ARule(sa=58, desc="Check message type compatability on reply", author="michal.chmielewski@oracle.com", date="02/22/2007", errors="BPELC__PA_PARTS")
    public void rule_CheckVariableAndMessageStructureCompatibility_20() {
        if (this.isUndefined(this.fOutMessage) || this.isUndefined(this.fVariable)) {
            return;
        }
        INode varType = this.getValue(this.fVariable, "type", null);
        if (this.isUndefined(varType)) {
            return;
        }
        if (!this.mModelQuery.check(3, varType, this.fOutMessage)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PA__MESSAGE_TYPE_MISMATCH", this.toString(this.mNode.nodeName()), AT_VARIABLE, this.fVariable.getAttribute(AT_NAME), this.fOutMessage, varType);
        }
    }

    @ARule(sa=59, desc="Check to see if toPart is specified; if so then  variable must not be used on the reply.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__PA_PARTS")
    public void rule_checkToPartsPresence_50() {
        List<INode> fFromParts = mSelector.selectNodes(this.mNode, ND_TO_PARTS, ND_TO_PART);
        if (fFromParts.size() > 0 && !ReplyValidator.isEmpty(this.fVariableName)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__PA_PARTS", this.toString(this.mNode.nodeName()), ND_TO_PART, AT_VARIABLE, 1);
        }
    }
}

