/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.provider;

import java.util.List;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.m2e.pde.MavenTargetLocation;

public class MavenTargetTreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)parentElement;
            List nodes = location.getDependencyNodes();
            if (nodes != null) {
                for (DependencyNode dependencyNode : nodes) {
                    if (!dependencyNode.getData().containsKey("dependencynode.root")) continue;
                    dependencyNode.setData((Object)"dependencynode.parent", parentElement);
                    return this.getChildren(dependencyNode);
                }
            }
        } else if (parentElement instanceof DependencyNode) {
            Object[] dependencyNodes;
            Object[] objectArray = dependencyNodes = ((DependencyNode)parentElement).getChildren().toArray(new DependencyNode[0]);
            int n = dependencyNodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object dependencyNode = objectArray[n2];
                dependencyNode.setData((Object)"dependencynode.parent", parentElement);
                ++n2;
            }
            return dependencyNodes;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof DependencyNode) {
            DependencyNode dp;
            DependencyNode dependencyNode = (DependencyNode)element;
            Object parent = dependencyNode.getData().get("dependencynode.parent");
            if (parent instanceof DependencyNode && (dp = (DependencyNode)parent).getData().containsKey("dependencynode.root")) {
                return this.getParent(dp);
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)element;
            List dependencyNodes = location.getDependencyNodes();
            return dependencyNodes != null && !dependencyNodes.isEmpty();
        }
        if (element instanceof DependencyNode) {
            DependencyNode node = (DependencyNode)element;
            return !node.getChildren().isEmpty();
        }
        return false;
    }
}

