/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.part.specific;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.ordering.AbstractNodeDecorateSemanticElementOrdering;

public abstract class AbstractExtendableEdgeEditPart
extends DEdgeEditPart {
    private static final ConnectionRouter ROUTER = new BendpointConnectionRouter();

    public AbstractExtendableEdgeEditPart(View view) {
        super(view);
    }

    public abstract List<EObject> getObjectsToShow();

    public abstract AbstractNodeDecorateSemanticElementOrdering getElementOrdering();

    public EObject getSemanticObject() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            return ((DEdge)element).getTarget();
        }
        return null;
    }

    @Override
    protected void installRouter() {
        super.installRouter();
        if (this.resolveSemanticElement() instanceof DEdge) {
            this.getPrimaryShape().setConnectionRouter(ROUTER);
        }
    }

    public abstract void paintElement(Graphics var1, EObject var2, Point var3);

    public class ExtendableEdgeFigure
    extends AbstractDiagramEdgeEditPart.ViewEdgeFigure {
        public ExtendableEdgeFigure() {
            super(AbstractExtendableEdgeEditPart.this);
        }

        @Override
        public void paintFigure(Graphics graphics) {
            EObject element = AbstractExtendableEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element)) {
                super.paintFigure(graphics);
                ArrayList<EObject> objects = new ArrayList<EObject>(AbstractExtendableEdgeEditPart.this.getObjectsToShow());
                final AbstractNodeDecorateSemanticElementOrdering ordering = AbstractExtendableEdgeEditPart.this.getElementOrdering();
                if (ordering != null) {
                    Collections.sort(objects, new Comparator<EObject>(){

                        @Override
                        public int compare(EObject arg0, EObject arg1) {
                            return ordering.compare(arg0, arg1);
                        }
                    });
                }
                Point firstPoint = this.getStart().x < this.getEnd().x ? this.getStart() : this.getEnd();
                Point lastPoint = this.getStart().x < this.getEnd().x ? this.getEnd() : this.getStart();
                int lengthX = lastPoint.x - firstPoint.x;
                int stepX = lengthX / (objects.size() + 1);
                int lengthY = lastPoint.y - firstPoint.y;
                int stepY = lengthY / (objects.size() + 1);
                int i = 0;
                while (i < objects.size()) {
                    EObject edgeElement = (EObject)objects.get(i);
                    int currentStepX = stepX * (i + 1);
                    int currentX = firstPoint.x + currentStepX;
                    int currentStepY = stepY * (i + 1);
                    int currentY = firstPoint.y + currentStepY;
                    AbstractExtendableEdgeEditPart.this.paintElement(graphics, edgeElement, new Point(currentX, currentY));
                    ++i;
                }
            }
        }
    }
}

