/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Pair;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.BendOnSegmentDragHandler;
import org.eclipse.gef.mvc.fx.handlers.ConnectedSupport;
import org.eclipse.gef.mvc.fx.handlers.IOnDragHandler;
import org.eclipse.gef.mvc.fx.handlers.SnapToSupport;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.policies.TransformPolicy;

public class TranslateSelectedOnDragHandler
extends AbstractHandler
implements IOnDragHandler {
    private ConnectedSupport connectedSupport;
    private SnapToSupport snapToSupport = null;
    private Point initialMouseLocationInScene = null;
    private Map<IContentPart<? extends Node>, Integer> translationIndices = new HashMap<IContentPart<? extends Node>, Integer>();
    private List<Pair<IContentPart<? extends Node>, TransformPolicy>> targets;
    private boolean invalidGesture = false;
    private Map<IContentPart<? extends Node>, Rectangle> boundsInScene = new IdentityHashMap<IContentPart<? extends Node>, Rectangle>();

    @Override
    public void abortDrag() {
        if (this.invalidGesture) {
            return;
        }
        for (Pair<IContentPart<? extends Node>, TransformPolicy> pair : this.targets) {
            this.rollback((IPolicy)pair.getValue());
            this.restoreRefreshVisuals((IVisualPart)pair.getKey());
        }
        if (this.snapToSupport != null) {
            this.snapToSupport.stopSnapping();
            this.snapToSupport = null;
        }
        if (this.connectedSupport != null) {
            this.connectedSupport.abort();
            this.connectedSupport = null;
        }
        this.targets = null;
        this.setInitialMouseLocationInScene(null);
        this.translationIndices.clear();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        boolean performSnapping = !this.isPrecise(e);
        for (Pair<IContentPart<? extends Node>, TransformPolicy> pair : this.targets) {
            Point startInScene = this.boundsInScene.get(pair.getKey()).getTopLeft();
            Point endInScene = startInScene.getTranslated(delta);
            if (this.snapToSupport != null) {
                if (performSnapping) {
                    endInScene.translate(this.snapToSupport.snap(delta));
                } else {
                    this.snapToSupport.clearSnappingFeedback();
                }
            }
            Point newEndInScene = endInScene.getCopy();
            Point newEndInParent = NodeUtils.sceneToLocal((Node)((IContentPart)pair.getKey()).getVisual().getParent(), (Point)newEndInScene);
            Point startInParent = NodeUtils.sceneToLocal((Node)((IContentPart)pair.getKey()).getVisual().getParent(), (Point)startInScene);
            Point deltaInParent = newEndInParent.getTranslated(startInParent.getNegated());
            ((TransformPolicy)pair.getValue()).setPostTranslate(this.translationIndices.get(pair.getKey()), deltaInParent.x, deltaInParent.y);
        }
        if (this.connectedSupport != null) {
            this.connectedSupport.normalizeConnected();
            this.connectedSupport.relocateHints(delta);
        }
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (Pair<IContentPart<? extends Node>, TransformPolicy> pair : this.targets) {
            this.commit((IPolicy)pair.getValue());
            this.restoreRefreshVisuals((IVisualPart)pair.getKey());
        }
        if (this.snapToSupport != null) {
            this.snapToSupport.stopSnapping();
            this.snapToSupport = null;
        }
        if (this.connectedSupport != null) {
            this.connectedSupport.commit();
            this.connectedSupport = null;
        }
        this.targets = null;
        this.setInitialMouseLocationInScene(null);
        this.translationIndices.clear();
    }

    protected ConnectedSupport getConnectedSupport() {
        return this.connectedSupport;
    }

    protected Point getInitialMouseLocationInScene() {
        return this.initialMouseLocationInScene;
    }

    protected SnapToSupport getSnapToSupport() {
        return this.snapToSupport;
    }

    protected List<IContentPart<? extends Node>> getTargetParts() {
        return ((SelectionModel)((Object)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class))).getSelectionUnmodifiable();
    }

    protected TransformPolicy getTransformPolicy(IContentPart<? extends Node> part) {
        return (TransformPolicy)part.getAdapter(TransformPolicy.class);
    }

    @Override
    public void hideIndicationCursor() {
    }

    protected boolean isPrecise(MouseEvent e) {
        return e.isShortcutDown();
    }

    protected boolean isTranslate(MouseEvent event, List<IContentPart<? extends Node>> targetParts) {
        IContentPart<? extends Node> part;
        Object visual;
        if (targetParts.size() == 1 && targetParts.get(0).getAdapter(BendOnSegmentDragHandler.class) != null && (visual = (part = targetParts.get(0)).getVisual()) instanceof Connection && ((Connection)visual).getRouter() instanceof OrthogonalRouter && (((Connection)visual).isStartConnected() || ((Connection)visual).isEndConnected())) {
            targetParts = null;
        }
        return targetParts != null && !targetParts.isEmpty();
    }

    protected void setInitialMouseLocationInScene(Point point) {
        this.initialMouseLocationInScene = point;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        List<IContentPart<? extends Node>> targetParts = this.getTargetParts();
        this.targets = new ArrayList<Pair<IContentPart<? extends Node>, TransformPolicy>>();
        boolean bl = this.invalidGesture = !this.isTranslate(e, targetParts);
        if (this.invalidGesture) {
            return;
        }
        this.setInitialMouseLocationInScene(new Point(e.getSceneX(), e.getSceneY()));
        for (IContentPart<? extends Node> part : targetParts) {
            TransformPolicy policy = (TransformPolicy)part.getAdapter(TransformPolicy.class);
            if (policy == null) continue;
            this.targets.add((Pair<IContentPart<? extends Node>, TransformPolicy>)new Pair(part, (Object)policy));
            this.storeAndDisableRefreshVisuals(part);
            this.init(policy);
            this.translationIndices.put(part, policy.createPostTransform());
            Rectangle shapeBounds = NodeUtils.getShapeBounds((Node)this.getHost().getVisual());
            Rectangle shapeBoundsInScene = NodeUtils.localToScene((Node)this.getHost().getVisual(), (IGeometry)shapeBounds).getBounds();
            this.boundsInScene.put(part, shapeBoundsInScene);
        }
        this.snapToSupport = null;
        if (((SelectionModel)((Object)this.getHost().getViewer().getAdapter(SelectionModel.class))).getSelectionUnmodifiable().size() == 1 && ((SelectionModel)((Object)this.getHost().getViewer().getAdapter(SelectionModel.class))).getSelectionUnmodifiable().contains(this.getHost())) {
            this.snapToSupport = (SnapToSupport)((Object)this.getHost().getViewer().getAdapter(SnapToSupport.class));
            if (this.snapToSupport != null) {
                this.snapToSupport.startSnapping((IContentPart)this.getHost());
            }
        }
        this.connectedSupport = (ConnectedSupport)((Object)this.getHost().getViewer().getAdapter(ConnectedSupport.class));
        if (this.connectedSupport != null) {
            this.connectedSupport.init(targetParts);
        }
    }
}

