/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.DeferredResourceChangeHandler;
import org.eclipse.team.internal.ccvs.core.util.SyncFileWriter;

public class SyncFileChangeListener
implements IResourceChangeListener {
    protected int INTERESTING_CHANGES = 323840;
    protected boolean isProjectOpening = false;
    protected static DeferredResourceChangeHandler deferredHandler = new DeferredResourceChangeHandler();

    public static DeferredResourceChangeHandler getDeferredHandler() {
        return deferredHandler;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final HashSet changedContainers = new HashSet();
            final HashSet externalDeletions = new HashSet();
            this.setProjectOpening(false);
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 8) {
                        return true;
                    }
                    if (resource.getType() == 4) {
                        if (!resource.isAccessible()) {
                            return false;
                        }
                        SyncFileChangeListener.this.setProjectOpening((delta.getFlags() & 0x4000) != 0);
                    }
                    String name = resource.getName();
                    int kind = delta.getKind();
                    if (kind == 4 && (delta.getFlags() & SyncFileChangeListener.this.INTERESTING_CHANGES) == 0) {
                        return true;
                    }
                    if (name.equals("CVS")) {
                        SyncFileChangeListener.this.handleCVSDir((IContainer)resource, kind);
                        if (SyncFileChangeListener.this.isProjectOpening()) {
                            return false;
                        }
                    } else if (SyncFileChangeListener.this.isProjectOpening()) {
                        return true;
                    }
                    if (SyncFileChangeListener.this.isMetaFile(resource)) {
                        IContainer[] toBeNotified = SyncFileChangeListener.this.handleChangedMetaFile(resource);
                        if (toBeNotified.length > 0 && SyncFileChangeListener.this.isModifiedBy3rdParty(resource)) {
                            Collections.addAll(changedContainers, toBeNotified);
                            if (Policy.DEBUG_METAFILE_CHANGES) {
                                System.out.println("[cvs] metafile changed by 3rd party: " + resource.getFullPath());
                            }
                            return false;
                        }
                    } else if (SyncFileChangeListener.this.isIgnoreFile(resource) && SyncFileChangeListener.this.isModifiedBy3rdParty(resource)) {
                        deferredHandler.ignoreFileChanged((IFile)resource);
                    } else if (SyncFileChangeListener.this.isExternalDeletion(resource, kind)) {
                        externalDeletions.add(resource);
                    } else if (kind == 1 && SyncFileChangeListener.this.isRecreation(resource)) {
                        deferredHandler.recreated(resource);
                    }
                    return true;
                }
            }, 2);
            if (!changedContainers.isEmpty() || !externalDeletions.isEmpty()) {
                EclipseSynchronizer.getInstance().syncFilesChangedExternally(changedContainers.toArray(new IContainer[changedContainers.size()]), externalDeletions.toArray(new IFile[externalDeletions.size()]));
            }
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }

    protected boolean isExternalDeletion(IResource resource, int kind) {
        if (kind != 2) {
            return false;
        }
        if (resource.getType() != 1) {
            return false;
        }
        ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
        try {
            return !file.isManaged() && file.getParent().isCVSFolder() && file.getParent().exists();
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return false;
        }
    }

    protected boolean isModifiedBy3rdParty(IResource resource) {
        Long whenWeWrote;
        if (!resource.exists()) {
            return true;
        }
        long modStamp = resource.getModificationStamp();
        try {
            whenWeWrote = (Long)resource.getSessionProperty(SyncFileWriter.MODSTAMP_KEY);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
            whenWeWrote = null;
        }
        return whenWeWrote == null || whenWeWrote != modStamp;
    }

    protected void handleCVSDir(IContainer cvsDir, int kind) {
        if ((kind & 0x1F) != 0 && kind == 1) {
            IFile rootFile = cvsDir.getFile((IPath)new Path("Root"));
            IFile repositoryFile = cvsDir.getFile((IPath)new Path("Repository"));
            if (rootFile.exists() && repositoryFile.exists() && !cvsDir.isTeamPrivateMember()) {
                try {
                    cvsDir.setTeamPrivateMember(true);
                    if (Policy.DEBUG_METAFILE_CHANGES) {
                        System.out.println("[cvs] found a new CVS meta folder, marking as team-private: " + cvsDir.getFullPath());
                    }
                }
                catch (CoreException e) {
                    CVSProviderPlugin.log((CoreException)((Object)CVSException.wrapException((IResource)cvsDir, CVSMessages.SyncFileChangeListener_errorSettingTeamPrivateFlag, e)));
                }
            }
        }
    }

    protected boolean isIgnoreFile(IResource resource) {
        return resource.getType() == 1 && resource.getName().equals(".cvsignore");
    }

    private boolean isRecreation(IResource resource) {
        return EclipseSynchronizer.getInstance().wasPhantom(resource);
    }

    protected boolean isMetaFile(IResource resource) {
        IContainer parent = resource.getParent();
        return resource.getType() == 1 && parent != null && parent.getName().equals("CVS") && (parent.isTeamPrivateMember() || !parent.exists());
    }

    protected IContainer[] handleChangedMetaFile(IResource resource) {
        IContainer changedContainer = resource.getParent().getParent();
        if (changedContainer.exists()) {
            return new IContainer[]{changedContainer};
        }
        return new IContainer[0];
    }

    public boolean isProjectOpening() {
        return this.isProjectOpening;
    }

    public void setProjectOpening(boolean isProjectOpening) {
        this.isProjectOpening = isProjectOpening;
    }
}

