/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.databinding.validators;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class AutConfigNameValidator
implements IValidator {
    private IAUTMainPO m_aut;
    private IAUTConfigPO m_currentConfig;

    public AutConfigNameValidator(IAUTMainPO aut, IAUTConfigPO currentConfig) {
        this.m_aut = aut;
        this.m_currentConfig = currentConfig;
    }

    public IStatus validate(Object value) {
        String stringValue = String.valueOf(value);
        ArrayList<String> componentNames = new ArrayList<String>();
        Set autConfigs = this.m_aut.getAutConfigSet();
        for (IAUTConfigPO config : autConfigs) {
            if (this.m_currentConfig == null || config.equals(this.m_currentConfig)) continue;
            componentNames.add(config.getName());
        }
        if (componentNames.contains(stringValue)) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.AUTConfigComponentDuplicateAUTConfigName, (Object[])new String[]{stringValue, this.m_aut.getName()}));
        }
        return ValidationStatus.ok();
    }
}

