/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.CommandCanceledException;
import com.google.gwt.user.client.IncrementalCommand;
import com.google.gwt.user.client.IncrementalCommandCanceledException;
import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandExecutor {
    private static final int DEFAULT_CANCELLATION_TIMEOUT_MILLIS = 10000;
    private static final int DEFAULT_TIME_SLICE_MILLIS = 100;
    private final Timer cancellationTimer = new Timer(){

        public void run() {
            if (!CommandExecutor.this.isExecuting()) {
                return;
            }
            CommandExecutor.this.doCommandCanceled();
        }
    };
    private final List<Object> commands = new ArrayList<Object>();
    private boolean executing = false;
    private final Timer executionTimer = new Timer(){

        public void run() {
            assert (!CommandExecutor.this.isExecuting());
            CommandExecutor.this.setExecutionTimerPending(false);
            CommandExecutor.this.doExecuteCommands(Duration.currentTimeMillis());
        }
    };
    private boolean executionTimerPending = false;
    private final CircularIterator iterator = new CircularIterator();

    CommandExecutor() {
    }

    private static boolean hasTimeSliceExpired(double currentTimeMillis, double startTimeMillis) {
        return currentTimeMillis - startTimeMillis >= 100.0;
    }

    public void submit(Command command) {
        this.commands.add(command);
        this.maybeStartExecutionTimer();
    }

    public void submit(IncrementalCommand command) {
        this.commands.add(command);
        this.maybeStartExecutionTimer();
    }

    protected void doCommandCanceled() {
        GWT.UncaughtExceptionHandler ueh;
        Object cmd = this.iterator.getLast();
        this.iterator.remove();
        assert (cmd != null);
        RuntimeException ex = null;
        if (cmd instanceof Command) {
            ex = new CommandCanceledException((Command)cmd);
        } else if (cmd instanceof IncrementalCommand) {
            ex = new IncrementalCommandCanceledException((IncrementalCommand)cmd);
        }
        if (ex != null && (ueh = GWT.getUncaughtExceptionHandler()) != null) {
            ueh.onUncaughtException(ex);
        }
        this.setExecuting(false);
        this.maybeStartExecutionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecuteCommands(double startTimeMillis) {
        block20: {
            assert (!this.isExecutionTimerPending());
            boolean wasCanceled = false;
            try {
                boolean removeCommand;
                block22: {
                    Object element;
                    block21: {
                        this.setExecuting(true);
                        this.iterator.setEnd(this.commands.size());
                        this.cancellationTimer.schedule(10000);
                        if (!this.iterator.hasNext()) break block20;
                        element = this.iterator.next();
                        removeCommand = true;
                        try {
                            if (element != null) break block21;
                        }
                        catch (Throwable throwable) {
                            wasCanceled = this.iterator.wasRemoved();
                            if (wasCanceled) {
                                return;
                            }
                            if (removeCommand) {
                                this.iterator.remove();
                            }
                            throw throwable;
                        }
                        wasCanceled = this.iterator.wasRemoved();
                        if (wasCanceled) {
                            return;
                        }
                        if (removeCommand) {
                            this.iterator.remove();
                        }
                        return;
                    }
                    if (element instanceof Command) {
                        Command command = (Command)element;
                        command.execute();
                        break block22;
                    }
                    if (!(element instanceof IncrementalCommand)) break block22;
                    IncrementalCommand incrementalCommand = (IncrementalCommand)element;
                    removeCommand = !incrementalCommand.execute();
                }
                wasCanceled = this.iterator.wasRemoved();
                if (wasCanceled) {
                    return;
                }
                if (removeCommand) {
                    this.iterator.remove();
                }
            }
            finally {
                if (!wasCanceled) {
                    this.cancellationTimer.cancel();
                    this.setExecuting(false);
                    this.maybeStartExecutionTimer();
                }
            }
        }
    }

    protected void maybeStartExecutionTimer() {
        if (!(this.commands.isEmpty() || this.isExecutionTimerPending() || this.isExecuting())) {
            this.setExecutionTimerPending(true);
            this.executionTimer.schedule(1);
        }
    }

    List<Object> getPendingCommands() {
        return this.commands;
    }

    void setExecuting(boolean executing) {
        this.executing = executing;
    }

    void setLast(int last) {
        this.iterator.setLast(last);
    }

    private boolean isExecuting() {
        return this.executing;
    }

    private boolean isExecutionTimerPending() {
        return this.executionTimerPending;
    }

    private void setExecutionTimerPending(boolean pending) {
        this.executionTimerPending = pending;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CircularIterator
    implements Iterator<Object> {
        private int end;
        private int last = -1;
        private int next = 0;

        private CircularIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next < this.end;
        }

        @Override
        public Object next() {
            this.last = this.next;
            Object command = CommandExecutor.this.commands.get(this.next++);
            if (this.next >= this.end) {
                this.next = 0;
            }
            return command;
        }

        @Override
        public void remove() {
            assert (this.last >= 0);
            CommandExecutor.this.commands.remove(this.last);
            --this.end;
            if (this.last <= this.next && --this.next < 0) {
                this.next = 0;
            }
            this.last = -1;
        }

        private Object getLast() {
            assert (this.last >= 0);
            return CommandExecutor.this.commands.get(this.last);
        }

        private void setEnd(int end) {
            assert (end >= this.next);
            this.end = end;
        }

        private void setLast(int last) {
            this.last = last;
        }

        private boolean wasRemoved() {
            return this.last == -1;
        }
    }
}

