/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.widget;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.provider.DimensionInfo;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.widget.AbstractWidgetProvider;
import org.eclipse.jst.pagedesigner.css2.widget.BorderUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ComboWidgetProvider
extends AbstractWidgetProvider {
    private static final int VERTICAL_PADDING = 6;
    private static final int HORIZONTAL_PADDING = 12;
    private static int ARRAWWIDTH = 16;
    private String _firstString;
    private String _longestString;
    private String _label;

    public ComboWidgetProvider(ICSSStyle style) {
        super(style);
    }

    public DimensionInfo getPreferredDimension(int width, int height) {
        if (width <= 0) {
            width = this.getDefaultWidth();
        }
        if (height <= 0) {
            height = this.getDefaultHeight();
        }
        return new DimensionInfo(new Dimension(width, height), -1);
    }

    private int getDefaultWidth() {
        int textareaWidth;
        if (this._longestString == null || this._longestString.length() == 0) {
            textareaWidth = 20;
        } else {
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            ICSSFont font = style.getCSSFont();
            textareaWidth = FigureUtilities.getTextWidth((String)this._longestString, (Font)font.getSwtFont());
        }
        return textareaWidth + ARRAWWIDTH + 12;
    }

    public int getDefaultHeight() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            style = DefaultStyle.getInstance();
        }
        ICSSFont font = style.getCSSFont();
        Font swtfont = font.getSwtFont();
        int fontSize = FigureUtilities.getFontMetrics((Font)swtfont).getHeight();
        return fontSize + 6;
    }

    public void paintFigure(Graphics g, Rectangle rect) {
        if (this._firstString != null) {
            ICSSStyle style = this.getCSSStyle();
            if (style == null) {
                style = DefaultStyle.getInstance();
            }
            ICSSFont font = style.getCSSFont();
            g.setFont(font.getSwtFont());
            Color newColor = null;
            Object color = style.getColor();
            if (color instanceof Color) {
                g.setForegroundColor((Color)color);
            } else if (color instanceof RGB) {
                newColor = new Color((Device)Display.getCurrent(), (RGB)color);
                g.setForegroundColor(newColor);
            } else {
                g.setForegroundColor(ColorConstants.black);
            }
            g.clipRect(rect);
            String label = this._label != null ? this._label : this._firstString;
            label = label.replaceAll("[ \r\n]+", " ");
            if (label.endsWith(" ")) {
                label = label.substring(0, label.length() - 1);
            }
            g.drawString(label, rect.x + 6, rect.y + 3);
            if (newColor != null) {
                newColor.dispose();
            }
        }
        BorderUtil.drawBorder(g, rect.x, rect.y, rect.width, rect.height, 2, true);
        int width = ARRAWWIDTH;
        int left = rect.x + rect.width - width - 2;
        int top = rect.y + 2;
        int height = rect.height - 4;
        g.setBackgroundColor(ColorConstants.button);
        g.fillRectangle(left, top, width, height);
        Rectangle borderRect = new Rectangle(left, top, width, height);
        BorderUtil.drawBorder(g, borderRect.x, borderRect.y, borderRect.width, borderRect.height, 2, false);
        g.setForegroundColor(ColorConstants.black);
        int decoratorWidth = (width - 4) / 2;
        int length = decoratorWidth / 2 + 1;
        int leftX = left + (width - decoratorWidth) / 2 - 1;
        int topY = top + (height - length) / 2 + 1;
        int i = 0;
        while (i < length) {
            g.drawLine(leftX + i, topY + i, leftX - i + decoratorWidth, topY + i);
            ++i;
        }
    }

    public void setOptions(String[] options) {
        if (options == null || options.length == 0) {
            this._firstString = null;
            this._longestString = null;
        } else {
            this._firstString = options[0];
            this._longestString = options[0] == null ? "" : options[0];
            int i = 1;
            while (i < options.length) {
                if (options[i] != null && options[i].length() > this._longestString.length()) {
                    this._longestString = options[i];
                }
                ++i;
            }
        }
    }

    public void setSelectedLabel(String label) {
        this._label = label;
    }

    public boolean isHandlingBorder() {
        return false;
    }
}

