/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ColorButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ColorPalette;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.pagedesigner.ui.dialogs.ColorUtil;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.ui.dialogs.IStyleConstants;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class BackgroundPreferencePage
extends PreferencePage {
    private CSSPropertyContext _style;
    private StyleCombo _backgroundImageCombo;
    private StyleCombo _backgroundRepeatCombo;
    private StyleCombo _backgroundAttachmentCombo;
    private StyleCombo _horizontalNumberCombo;
    private StyleCombo _horizontalUnitCombo;
    private StyleCombo _verticalNumberCombo;
    private StyleCombo _verticalUnitCombo;
    private ColorButtonDialogField _backgroundColorField;

    public BackgroundPreferencePage(IDOMElement element, CSSPropertyContext style) {
        this._style = style;
        this.setTitle(DialogsMessages.getString("BackgroundPreferencePage.Title"));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        GridData data = new GridData(1808);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)data);
        this._backgroundColorField = new ColorButtonDialogField(2048, (ColorPalette)new ColorUtil());
        this._backgroundColorField.setLabelText(DialogsMessages.getString("BackgroundBoxPreferencePage.BackgroundColor"));
        data = new GridData(128);
        this._backgroundColorField.getLabelControl(null, top).setLayoutData((Object)data);
        data = new GridData(768);
        this._backgroundColorField.getComboControl(null, top).setLayoutData((Object)data);
        data = new GridData();
        this._backgroundColorField.getChangeControl(null, top).setLayoutData((Object)data);
        this._backgroundColorField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                String color = BackgroundPreferencePage.this._backgroundColorField.getText();
                BackgroundPreferencePage.this._style.setBackgroundColor(color);
            }
        });
        Label backgroundImageLabel = new Label(top, 0);
        backgroundImageLabel.setText(DialogsMessages.getString("BackgroundBoxPreferencePage.BackgroundImage"));
        data = new GridData(128);
        backgroundImageLabel.setLayoutData((Object)data);
        this._backgroundImageCombo = new StyleCombo(top, 0);
        this._backgroundImageCombo.setItems(IStyleConstants.NONE);
        data = new GridData(768);
        this._backgroundImageCombo.setLayoutData(data);
        this._backgroundImageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String image = BackgroundPreferencePage.this._backgroundImageCombo.getText();
                BackgroundPreferencePage.this._style.setBackgroundImage(image);
            }
        });
        new Label(top, 0);
        Label backgroundRepeatLabel = new Label(top, 0);
        backgroundRepeatLabel.setText(DialogsMessages.getString("BackgroundBoxPreferencePage.BackgroundRepeatLabel"));
        data = new GridData(128);
        backgroundRepeatLabel.setLayoutData((Object)data);
        this._backgroundRepeatCombo = new StyleCombo(top, 0);
        this._backgroundRepeatCombo.setItems(IStyleConstants.REPEAT);
        data = new GridData(768);
        this._backgroundRepeatCombo.setLayoutData(data);
        this._backgroundRepeatCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String repeat = BackgroundPreferencePage.this._backgroundRepeatCombo.getText();
                BackgroundPreferencePage.this._style.setBackgroundRepeat(repeat);
            }
        });
        new Label(top, 0);
        Label backgroundAttachmentLabel = new Label(top, 0);
        backgroundAttachmentLabel.setText(DialogsMessages.getString("BackgroundBoxPreferencePage.BackgroundAttachmentLabel"));
        data = new GridData(128);
        backgroundAttachmentLabel.setLayoutData((Object)data);
        this._backgroundAttachmentCombo = new StyleCombo(top, 0);
        this._backgroundAttachmentCombo.setItems(IStyleConstants.ATTACHMENT);
        data = new GridData(768);
        this._backgroundAttachmentCombo.setLayoutData(data);
        this._backgroundAttachmentCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String attachment = BackgroundPreferencePage.this._backgroundAttachmentCombo.getText();
                BackgroundPreferencePage.this._style.setBackgroundAttachment(attachment);
            }
        });
        new Label(top, 0);
        Label backgroundHorizontalLabel = new Label(top, 0);
        backgroundHorizontalLabel.setText(DialogsMessages.getString("BackgroundBoxPreferencePage.HorizontalLabel"));
        data = new GridData(128);
        backgroundHorizontalLabel.setLayoutData((Object)data);
        this._horizontalNumberCombo = new StyleCombo(top, 0);
        this._horizontalNumberCombo.setItems(IStyleConstants.POSITION);
        data = new GridData(768);
        this._horizontalNumberCombo.setLayoutData(data);
        this._horizontalNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BackgroundPreferencePage.this._horizontalUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(BackgroundPreferencePage.this._horizontalNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    BackgroundPreferencePage.this._horizontalUnitCombo.setEnabled(false);
                }
                String position = BackgroundPreferencePage.this._horizontalNumberCombo.getText();
                if (BackgroundPreferencePage.this._horizontalUnitCombo.isEnabled()) {
                    position = String.valueOf(position) + BackgroundPreferencePage.this._horizontalUnitCombo.getText();
                }
                BackgroundPreferencePage.this._style.setBackgroundPositionX(position);
            }
        });
        this._horizontalUnitCombo = new StyleCombo(top, 8);
        this._horizontalUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(4);
        this._horizontalUnitCombo.setLayoutData(data);
        this._horizontalUnitCombo.select(0);
        this._horizontalUnitCombo.setEnabled(false);
        this._horizontalUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String position = BackgroundPreferencePage.this._horizontalNumberCombo.getText();
                if (BackgroundPreferencePage.this._horizontalUnitCombo.isEnabled()) {
                    position = String.valueOf(position) + BackgroundPreferencePage.this._horizontalUnitCombo.getText();
                }
                BackgroundPreferencePage.this._style.setBackgroundPositionX(position);
            }
        });
        Label backgroundVerticalLabel = new Label(top, 0);
        backgroundVerticalLabel.setText(DialogsMessages.getString("BackgroundBoxPreferencePage.VerticalLabel"));
        data = new GridData(128);
        backgroundVerticalLabel.setLayoutData((Object)data);
        this._verticalNumberCombo = new StyleCombo(top, 0);
        this._verticalNumberCombo.setItems(IStyleConstants.POSITION);
        data = new GridData(768);
        this._verticalNumberCombo.setLayoutData(data);
        this._verticalNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BackgroundPreferencePage.this._verticalUnitCombo.setEnabled(true);
                try {
                    Integer.valueOf(BackgroundPreferencePage.this._verticalNumberCombo.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    BackgroundPreferencePage.this._verticalUnitCombo.setEnabled(false);
                }
                String position = BackgroundPreferencePage.this._verticalNumberCombo.getText();
                if (BackgroundPreferencePage.this._verticalUnitCombo.isEnabled()) {
                    position = String.valueOf(position) + BackgroundPreferencePage.this._verticalUnitCombo.getText();
                }
                BackgroundPreferencePage.this._style.setBackgroundPositionY(position);
            }
        });
        this._verticalUnitCombo = new StyleCombo(top, 8);
        this._verticalUnitCombo.setItems(IStyleConstants.SIZE_UNIT);
        data = new GridData(4);
        this._verticalUnitCombo.setLayoutData(data);
        this._verticalUnitCombo.select(0);
        this._verticalUnitCombo.setEnabled(false);
        this._verticalUnitCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String position = BackgroundPreferencePage.this._verticalNumberCombo.getText();
                if (BackgroundPreferencePage.this._verticalUnitCombo.isEnabled()) {
                    position = String.valueOf(position) + BackgroundPreferencePage.this._verticalUnitCombo.getText();
                }
                BackgroundPreferencePage.this._style.setBackgroundPositionY(position);
            }
        });
        this.initializeControls();
        return top;
    }

    private void initializeControls() {
        int index;
        String position;
        String attachment;
        String repeat;
        String image;
        String color = this._style.getBackgroundColor();
        if (!this.isEmptyString(color)) {
            this._backgroundColorField.setTextWithoutUpdate(color);
        }
        if (!this.isEmptyString(image = this._style.getBackgroundImage())) {
            int index2 = this._backgroundImageCombo.indexOf(image);
            if (index2 != -1) {
                this._backgroundImageCombo.select(index2);
            } else {
                this._backgroundImageCombo.setText(image);
            }
        }
        if (!this.isEmptyString(repeat = this._style.getBackgroundRepeat())) {
            int index3 = this._backgroundRepeatCombo.indexOf(repeat);
            if (index3 != -1) {
                this._backgroundRepeatCombo.select(index3);
            } else {
                this._backgroundRepeatCombo.setText(repeat);
            }
        }
        if (!this.isEmptyString(attachment = this._style.getBackgroundAttachment())) {
            int index4 = this._backgroundAttachmentCombo.indexOf(repeat);
            if (index4 != -1) {
                this._backgroundAttachmentCombo.select(index4);
            } else {
                this._backgroundAttachmentCombo.setText(attachment);
            }
        }
        if (!this.isEmptyString(position = this._style.getBackgroundPositionX())) {
            index = this._horizontalNumberCombo.indexOf(position);
            if (index != -1) {
                this._horizontalNumberCombo.select(index);
            } else {
                this._horizontalNumberCombo.setText(position);
            }
        }
        if (!this.isEmptyString(position = this._style.getBackgroundPositionY())) {
            index = this._verticalNumberCombo.indexOf(position);
            if (index != -1) {
                this._verticalNumberCombo.select(index);
            } else {
                this._verticalNumberCombo.setText(position);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getApplyButton().setVisible(false);
        this.getDefaultsButton().setVisible(false);
    }

    private boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

