/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentHeadContentDetector;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.TagMarker;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.rules.IStructuredTypedRegion;
import org.eclipse.wst.sse.core.internal.text.rules.StructuredTextPartitioner;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class StructuredTextPartitionerForJSP
extends StructuredTextPartitioner {
    private static final boolean fEnableJSPActionPartitions = true;
    private static List fJSPActionTagNames = null;
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String XHTML_MIME_TYPE = "text/xhtml";
    private static final String XML_MIME_TYPE = "text/xml";
    private static final String VND_WAP_WML = "text/vnd.wap.wml";
    private static final String[] fConfiguredContentTypes = new String[]{"org.eclipse.jst.jsp.DEFAULT_JSP", "org.eclipse.jst.jsp.SCRIPT.JSP_EL", "org.eclipse.jst.jsp.SCRIPT.JSP_EL2", "org.eclipse.jst.jsp.JSP_DIRECTIVE", "org.eclipse.jst.jsp.SCRIPT.DELIMITER", "org.eclipse.jst.jsp.SCRIPT.JAVA", "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT", "org.eclipse.jst.jsp.JSP_COMMENT"};
    private IStructuredTextPartitioner fEmbeddedPartitioner = null;
    private String fLastCheckedPrefix = null;
    private String fLanguage = "java";

    public static String[] getConfiguredContentTypes() {
        return fConfiguredContentTypes;
    }

    public StructuredTextPartitionerForJSP() {
        if (fJSPActionTagNames == null) {
            fJSPActionTagNames = new ArrayList();
            fJSPActionTagNames.add("jsp:declaration");
            fJSPActionTagNames.add("jsp:expression");
            fJSPActionTagNames.add("jsp:fallback");
            fJSPActionTagNames.add("jsp:forward");
            fJSPActionTagNames.add("jsp:getProperty");
            fJSPActionTagNames.add("jsp:include");
            fJSPActionTagNames.add("jsp:param");
            fJSPActionTagNames.add("jsp:params");
            fJSPActionTagNames.add("jsp:plugin");
            fJSPActionTagNames.add("jsp:scriptlet");
            fJSPActionTagNames.add("jsp:setProperty");
            fJSPActionTagNames.add("jsp:text");
            fJSPActionTagNames.add("jsp:useBean");
        }
    }

    public void connect(IDocument document) {
        super.connect(document);
        this.fSupportedTypes = null;
    }

    private IStructuredTextPartitioner createStructuredTextPartitioner(IStructuredDocument structuredDocument) {
        StructuredTextPartitionerForHTML result = null;
        JSPDocumentHeadContentDetector jspHeadContentDetector = new JSPDocumentHeadContentDetector();
        jspHeadContentDetector.set((IDocument)structuredDocument);
        String contentType = null;
        try {
            contentType = jspHeadContentDetector.getContentType();
            if (jspHeadContentDetector.isXHTML() || jspHeadContentDetector.isWML()) {
                contentType = HTML_MIME_TYPE;
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        if (contentType == null || contentType.length() == 0) {
            contentType = HTML_MIME_TYPE;
        }
        if (contentType.equalsIgnoreCase(HTML_MIME_TYPE) || contentType.equalsIgnoreCase(VND_WAP_WML)) {
            result = new StructuredTextPartitionerForHTML();
            result.connect((IDocument)structuredDocument);
        } else if (contentType.equalsIgnoreCase(XHTML_MIME_TYPE)) {
            result = new StructuredTextPartitionerForHTML();
            result.connect((IDocument)structuredDocument);
        } else if (contentType.equalsIgnoreCase(XML_MIME_TYPE) || contentType.endsWith("+xml")) {
            result = new StructuredTextPartitionerForXML();
            result.connect((IDocument)structuredDocument);
        } else {
            result = new StructuredTextPartitioner();
            result.connect((IDocument)structuredDocument);
        }
        return result;
    }

    public void disconnect() {
        if (this.fEmbeddedPartitioner != null) {
            this.fEmbeddedPartitioner.disconnect();
            this.fEmbeddedPartitioner = null;
        }
        super.disconnect();
    }

    public String getDefaultPartitionType() {
        return this.getEmbeddedPartitioner().getDefaultPartitionType();
    }

    public IStructuredTextPartitioner getEmbeddedPartitioner() {
        if (this.fEmbeddedPartitioner == null) {
            this.fEmbeddedPartitioner = this.createStructuredTextPartitioner(this.fStructuredDocument);
            this.fEmbeddedPartitioner.connect((IDocument)this.fStructuredDocument);
        }
        return this.fEmbeddedPartitioner;
    }

    public String getLanguage() {
        return this.fLanguage;
    }

    private List getLocalLegalContentTypes() {
        ArrayList<String> types = new ArrayList<String>();
        String[] configuredTypes = StructuredTextPartitionerForJSP.getConfiguredContentTypes();
        int i = 0;
        while (i < configuredTypes.length) {
            types.add(configuredTypes[i]);
            ++i;
        }
        return types;
    }

    private String getParentName(IStructuredDocumentRegion sdRegion) {
        ITextRegionList regions;
        String result = "UNKNOWN";
        while (sdRegion != null && this.isValidJspActionRegionType(sdRegion.getType())) {
            sdRegion = sdRegion.getPrevious();
        }
        if (sdRegion != null && (regions = sdRegion.getRegions()).size() > 1) {
            ITextRegion r = regions.get(1);
            if (regions.get(0).getType().equals("XML_TAG_OPEN") && r.getType().equals("XML_TAG_NAME")) {
                result = sdRegion.getText(r);
            }
        }
        return result;
    }

    protected String getPartitionType(ForeignRegion region, int offset) {
        return this.getEmbeddedPartitioner().getPartitionType((ITextRegion)region, offset);
    }

    public String getPartitionType(ITextRegion region, int offset) {
        IStructuredDocumentRegion sdRegion;
        String result = null;
        String region_type = region.getType();
        result = region_type == "JSP_CONTENT" ? this.getPartitionTypeForDocumentLanguage() : (region_type == "JSP_COMMENT_TEXT" || region_type == "JSP_COMMENT_OPEN" || region_type == "JSP_COMMENT_CLOSE" ? "org.eclipse.jst.jsp.JSP_COMMENT" : (region_type == "JSP_DIRECTIVE_NAME" || region_type == "JSP_DIRECTIVE_OPEN" || region_type == "JSP_DIRECTIVE_CLOSE" ? "org.eclipse.jst.jsp.JSP_DIRECTIVE" : (region_type == "JSP_CLOSE" || region_type == "JSP_SCRIPTLET_OPEN" || region_type == "JSP_EXPRESSION_OPEN" || region_type == "JSP_DECLARATION_OPEN" ? "org.eclipse.jst.jsp.SCRIPT.DELIMITER" : (region_type == "JSP_ROOT_TAG_NAME" ? "org.eclipse.jst.jsp.DEFAULT_JSP" : (region_type == "JSP_EL_OPEN" || region_type == "JSP_EL_CONTENT" || region_type == "JSP_EL_CLOSE" || region_type == "JSP_EL_DQUOTE" || region_type == "JSP_EL_SQUOTE" || region_type == "JSP_EL_QUOTED_CONTENT" ? "org.eclipse.jst.jsp.SCRIPT.JSP_EL" : (region_type == "JSP_VBL_OPEN" || region_type == "JSP_VBL_CONTENT" || region_type == "JSP_VBL_CLOSE" || region_type == "JSP_VBL_DQUOTE" || region_type == "JSP_VBL_SQUOTE" || region_type == "JSP_VBL_QUOTED_CONTENT" ? "org.eclipse.jst.jsp.SCRIPT.JSP_EL2" : (region_type == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || region_type == "XML_TAG_ATTRIBUTE_VALUE_SQUOTE" ? "org.eclipse.jst.jsp.DEFAULT_JSP" : (region_type == "XML_CDATA_TEXT" ? (this.isJspJavaActionName(this.getParentName(sdRegion = this.fStructuredDocument.getRegionAtCharacterOffset(offset))) ? this.getPartitionTypeForDocumentLanguage() : this.getEmbeddedPartitioner().getPartitionType(region, offset)) : (region_type == "XML_CONTENT" ? (this.isJspJavaActionName(this.getParentName(sdRegion = this.fStructuredDocument.getRegionAtCharacterOffset(offset))) ? this.getPartitionTypeForDocumentLanguage() : this.getDefaultPartitionType()) : this.getEmbeddedPartitioner().getPartitionType(region, offset))))))))));
        return result;
    }

    public String getPartitionTypeBetween(IStructuredDocumentRegion previousNode, IStructuredDocumentRegion nextNode) {
        return this.getEmbeddedPartitioner().getPartitionTypeBetween(previousNode, nextNode);
    }

    private String getPartitionTypeForDocumentLanguage() {
        String result = this.fLanguage == null || this.fLanguage.equalsIgnoreCase("java") ? "org.eclipse.jst.jsp.SCRIPT.JAVA" : (this.fLanguage.equalsIgnoreCase("javascript") ? "org.eclipse.jst.jsp.SCRIPT.JAVASCRIPT" : "org.eclipse.jst.jsp.SCRIPT." + this.getLanguage().toUpperCase(Locale.ENGLISH));
        return result;
    }

    protected void initLegalContentTypes() {
        List combinedTypes = this.getLocalLegalContentTypes();
        if (this.getEmbeddedPartitioner() != null) {
            String[] moreTypes = this.getEmbeddedPartitioner().getLegalContentTypes();
            int i = 0;
            while (i < moreTypes.length) {
                combinedTypes.add(moreTypes[i]);
                ++i;
            }
        }
        this.fSupportedTypes = new String[0];
        combinedTypes.toArray(this.fSupportedTypes);
    }

    private boolean isAction(IStructuredDocumentRegion sdRegion, int offset) {
        if (!sdRegion.getType().equals("XML_TAG_NAME")) {
            return false;
        }
        ITextRegion tagNameRegion = sdRegion.getRegions().get(1);
        String tagName = sdRegion.getText(tagNameRegion);
        RegionParser parser = this.fStructuredDocument.getParser();
        if (parser instanceof JSPSourceParser) {
            if (tagName.equals(this.fLastCheckedPrefix)) {
                return true;
            }
            List fCustomActionPrefixes = ((JSPSourceParser)parser).getNestablePrefixes();
            int i = 0;
            while (i < fCustomActionPrefixes.size()) {
                if (tagName.startsWith(((TagMarker)fCustomActionPrefixes.get(i)).getTagName())) {
                    this.fLastCheckedPrefix = ((TagMarker)fCustomActionPrefixes.get(i)).getTagName();
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean isDocumentRegionBasedPartition(IStructuredDocumentRegion sdRegion, ITextRegion containedChildRegion, int offset) {
        String documentRegionContext = sdRegion.getType();
        if (containedChildRegion != null) {
            if (documentRegionContext.equals("JSP_DIRECTIVE_NAME") || documentRegionContext.equals("JSP_ROOT_TAG_NAME")) {
                this.setInternalPartition(offset, containedChildRegion.getLength(), "org.eclipse.jst.jsp.JSP_DIRECTIVE");
                return true;
            }
            if (!this.isELRegion(containedChildRegion) && !this.isScriptletRegion(containedChildRegion) && this.isAction(sdRegion, offset) && !(containedChildRegion instanceof ITextRegionContainer)) {
                this.setInternalPartition(offset, containedChildRegion.getLength(), "org.eclipse.jst.jsp.JSP_DIRECTIVE");
                return true;
            }
        }
        return super.isDocumentRegionBasedPartition(sdRegion, containedChildRegion, offset);
    }

    private boolean isJspJavaActionName(String possibleJspJavaAction) {
        return possibleJspJavaAction.equals("jsp:scriptlet") || possibleJspJavaAction.equals("jsp:expression") || possibleJspJavaAction.equals("jsp:declaration");
    }

    private boolean isValidJspActionRegionType(String type) {
        return type == "XML_CONTENT" || type == "BLOCK_TEXT" || type == "XML_CDATA_OPEN" || type == "XML_CDATA_TEXT" || type == "XML_CDATA_CLOSE";
    }

    public IDocumentPartitioner newInstance() {
        StructuredTextPartitionerForJSP instance = new StructuredTextPartitionerForJSP();
        instance.setEmbeddedPartitioner(this.createStructuredTextPartitioner(this.fStructuredDocument));
        instance.setLanguage(this.fLanguage);
        return instance;
    }

    public void setEmbeddedPartitioner(IStructuredTextPartitioner embeddedPartitioner) {
        if (this.fEmbeddedPartitioner != null && this.fStructuredDocument != null) {
            this.fEmbeddedPartitioner.disconnect();
        }
        this.fEmbeddedPartitioner = embeddedPartitioner;
        if (this.fEmbeddedPartitioner != null && this.fStructuredDocument != null) {
            this.fEmbeddedPartitioner.connect((IDocument)this.fStructuredDocument);
        }
    }

    protected void setInternalPartition(int offset, int length, String type) {
        IStructuredTypedRegion region = this.getEmbeddedPartitioner().createPartition(offset, length, type);
        super.setInternalPartition(region.getOffset(), region.getLength(), region.getType());
    }

    public void setLanguage(String language) {
        this.fLanguage = language;
    }

    private boolean isELRegion(ITextRegion region) {
        String type = region.getType();
        return type == "JSP_EL_CLOSE" || type == "JSP_EL_CONTENT" || type == "JSP_EL_DQUOTE" || type == "JSP_EL_OPEN" || type == "JSP_EL_QUOTED_CONTENT" || type == "JSP_EL_SQUOTE" || type == "JSP_VBL_CLOSE" || type == "JSP_VBL_CONTENT" || type == "JSP_VBL_DQUOTE" || type == "JSP_VBL_OPEN" || type == "JSP_VBL_QUOTED_CONTENT" || type == "JSP_VBL_SQUOTE";
    }

    private boolean isScriptletRegion(ITextRegion region) {
        String type = region.getType();
        return type == "JSP_SCRIPTLET_OPEN" || type == "JSP_CLOSE" || type == "JSP_EXPRESSION_OPEN" || type == "JSP_DECLARATION_OPEN" || type == "JSP_CONTENT";
    }

    protected boolean doParserSpecificCheck(int offset, boolean partitionFound, IStructuredDocumentRegion sdRegion, IStructuredDocumentRegion previousStructuredDocumentRegion, ITextRegion next, ITextRegion previousStart) {
        if (previousStart != null && previousStart.getType() == "XML_TAG_OPEN" && next.getType() == "XML_END_TAG_OPEN") {
            ITextRegion previousName = previousStructuredDocumentRegion.getRegionAtCharacterOffset(previousStructuredDocumentRegion.getEndOffset(previousStart));
            ITextRegion nextName = sdRegion.getRegionAtCharacterOffset(sdRegion.getEndOffset(next));
            if (previousName != null && nextName != null && previousName.getType() == "XML_TAG_NAME" && nextName.getType() == "XML_TAG_NAME") {
                this.setInternalPartition(offset, 0, this.getPartitionTypeBetween(previousStructuredDocumentRegion, sdRegion));
                partitionFound = true;
            }
        }
        return partitionFound;
    }

    protected IStructuredDocumentRegion getParserSpecificPreviousRegion(IStructuredDocumentRegion currentRegion) {
        if (currentRegion == null) {
            return null;
        }
        while ((currentRegion = currentRegion.getPrevious()) != null && currentRegion.getType().equals("BLOCK_TEXT")) {
        }
        return currentRegion;
    }
}

