/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import java.util.ArrayList;
import org.eclipse.actf.util.win32.OverlayWindow;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class OverlayLabel
extends CLabel {
    public Object associatedObject;
    private Menu popupMenu;
    private static String ownerId = null;
    private static final String MENU_SEPARATOR = "\n----------------";

    private OverlayLabel(Composite composite, int n) {
        super(composite, n);
        this.setForeground(this.getDisplay().getSystemColor(28));
        this.setBackground(this.getDisplay().getSystemColor(29));
        this.setLayoutData(new GridData());
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = OverlayLabel.this.getClientArea();
                paintEvent.gc.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            }
        });
    }

    public static void removeAll() {
        OverlayLabel.removeAll(true);
    }

    public static void removeAll(boolean bl) {
        final Composite composite = OverlayLabel.getOverlayComposite(false);
        if (composite != null) {
            if (bl) {
                OverlayLabel.removeChildren(composite);
            } else {
                composite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!composite.isDisposed() && composite.getDisplay().getActiveShell() == null) {
                            OverlayLabel.removeChildren(composite);
                        }
                    }
                });
            }
        }
    }

    private static void removeChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof OverlayLabel) {
                controlArray[n].dispose();
            }
            ++n;
        }
    }

    public static OverlayLabel create(Object object) {
        Composite composite = OverlayLabel.getOverlayComposite(true);
        composite.moveAbove(null);
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof OverlayLabel && object.equals(((OverlayLabel)controlArray[n]).associatedObject)) {
                return null;
            }
            ++n;
        }
        OverlayLabel overlayLabel = new OverlayLabel(composite, 0);
        overlayLabel.associatedObject = object;
        return overlayLabel;
    }

    public static OverlayLabel[] getLabelsAtPosition(Point point) {
        ArrayList<OverlayLabel> arrayList = new ArrayList<OverlayLabel>();
        Composite composite = OverlayLabel.getOverlayComposite(false);
        if (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] instanceof OverlayLabel && controlArray[n].getBounds().contains(point)) {
                    arrayList.add((OverlayLabel)controlArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new OverlayLabel[arrayList.size()]);
    }

    private static Composite getOverlayComposite(boolean bl) {
        OverlayWindow overlayWindow = OverlayWindow.getInstance(1, bl);
        if (overlayWindow != null) {
            return overlayWindow.getComposite();
        }
        return null;
    }

    public Menu createPopupMenu() {
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        this.popupMenu = new Menu((Control)this);
        return this.popupMenu;
    }

    public void dispose() {
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        super.dispose();
    }

    public static String getOwnerId() {
        return ownerId;
    }

    public static void setOwnerId(String string) {
        ownerId = string;
    }

    public void setTooltop(String string, String[][] stringArray) {
        string = String.valueOf(string) + MENU_SEPARATOR;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n][1].length() > 0) {
                string = String.valueOf(string) + "\n" + stringArray[n][0] + ": " + stringArray[n][1];
            }
            ++n;
        }
        this.setToolTipText(string);
    }

    public String getMenuText() {
        String string = this.getToolTipText();
        int n = string.indexOf(MENU_SEPARATOR);
        if (n > 0) {
            string = string.substring(0, n);
        }
        string = string.replaceAll("\n", " | ");
        return string;
    }
}

