/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableLongIntMapFactory;
import org.eclipse.collections.api.map.primitive.ImmutableLongIntMap;
import org.eclipse.collections.api.map.primitive.LongIntMap;
import org.eclipse.collections.impl.factory.primitive.LongIntMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableLongIntSingletonMap;

public enum ImmutableLongIntMapFactoryImpl implements ImmutableLongIntMapFactory
{
    INSTANCE;


    public ImmutableLongIntMap empty() {
        return ImmutableLongIntEmptyMap.INSTANCE;
    }

    public ImmutableLongIntMap of() {
        return this.empty();
    }

    public ImmutableLongIntMap with() {
        return this.empty();
    }

    public ImmutableLongIntMap of(long key, int value) {
        return this.with(key, value);
    }

    public ImmutableLongIntMap with(long key, int value) {
        return new ImmutableLongIntSingletonMap(key, value);
    }

    public ImmutableLongIntMap ofAll(LongIntMap map) {
        return this.withAll(map);
    }

    public ImmutableLongIntMap withAll(LongIntMap map) {
        if (map instanceof ImmutableLongIntMap) {
            return (ImmutableLongIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongIntSingletonMap(key, map.get(key));
        }
        return new ImmutableLongIntHashMap(map);
    }

    public <T> ImmutableLongIntMap from(Iterable<T> iterable, LongFunction<? super T> keyFunction, IntFunction<? super T> valueFunction) {
        return LongIntMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

