/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.Hashes;
import org.eclipse.passage.lic.internal.api.io.HashesRegistry;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.internal.hc.remote.Connection;
import org.eclipse.passage.lic.internal.hc.remote.Request;
import org.eclipse.passage.lic.internal.hc.remote.RequestContext;
import org.eclipse.passage.lic.internal.hc.remote.impl.BaseRequestContext;
import org.eclipse.passage.lic.internal.hc.remote.impl.FloatingServerCoordinates;
import org.eclipse.passage.lic.internal.net.HostPort;
import org.eclipse.passage.lic.licenses.model.api.FloatingLicenseAccess;

public abstract class RemoteRequest<C extends Connection>
implements Request<C> {
    protected final LicensedProduct product;
    protected final FloatingLicenseAccess access;
    protected final String hash;

    public RemoteRequest(LicensedProduct product, FloatingLicenseAccess access, HashesRegistry hashes) {
        this.product = product;
        this.access = access;
        this.hash = ((StringServiceId)((Hashes)((Registry)hashes.get()).services().iterator().next()).id()).toString();
    }

    @Override
    public final URL url() throws LicensingException {
        try {
            HostPort corrdinates = new FloatingServerCoordinates(this.access).get();
            return new URL("http", corrdinates.host(), Integer.parseInt(corrdinates.port()), this.parameters().query());
        }
        catch (NumberFormatException | MalformedURLException | LicensingException e) {
            throw new LicensingException(AccessMessages.Request_failed_to_compose_url, e);
        }
    }

    @Override
    public final RequestContext context() {
        return new BaseRequestContext(this.product, this.hash);
    }
}

