/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.ui.ImageManager;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkbenchAdapter
implements IWorkbenchAdapter {
    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof ICompilationUnit) {
                return this.getCUMembers((ICompilationUnit)parentElement);
            }
            if (parentElement instanceof IOTType) {
                parentElement = ((IOTType)parentElement).getCorrespondingJavaElement();
            }
            if (parentElement instanceof IParent) {
                return ((IParent)parentElement).getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return new Object[0];
    }

    private Object[] getCUMembers(ICompilationUnit unit) throws JavaModelException {
        ArrayList<Object> result = new ArrayList<Object>();
        IType[] types = unit.getTypes();
        int idx = 0;
        while (idx < types.length) {
            if (OTModelManager.hasOTElementFor((IType)types[idx])) {
                result.add(OTModelManager.getOTElement((IType)types[idx]));
            } else {
                result.add(types[idx]);
            }
            ++idx;
        }
        return result.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor result = ImageDescriptor.getMissingImageDescriptor();
        try {
            if (element instanceof IOTType) {
                result = this.getTypeImageDescriptor((IOTType)element);
            } else if (element instanceof IMethodMapping) {
                result = this.getBindingImageDescriptor((IMethodMapping)element);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return result;
    }

    public String getLabel(Object elem) {
        if (elem instanceof IOTJavaElement) {
            return ((IOTJavaElement)elem).getElementName();
        }
        return null;
    }

    public Object getParent(Object elem) {
        if (elem instanceof IOTType) {
            IOTType otType = (IOTType)elem;
            return ((IType)otType.getCorrespondingJavaElement()).getParent();
        }
        return null;
    }

    private ImageDescriptor getTypeImageDescriptor(IOTType type) throws JavaModelException {
        if (type.isTeam()) {
            if (type.isRole()) {
                if ((type.getFlags() & 4) != 0) {
                    return ImageManager.getSharedInstance().getDescriptor("team_role_protected_obj.gif");
                }
                return ImageManager.getSharedInstance().getDescriptor("team_role_obj.gif");
            }
            return ImageManager.getSharedInstance().getDescriptor("team_obj.gif");
        }
        if ((type.getFlags() & 4) != 0) {
            return ImageManager.getSharedInstance().getDescriptor("role_protected_obj.png");
        }
        return ImageManager.getSharedInstance().getDescriptor("role_obj.png");
    }

    private ImageDescriptor getBindingImageDescriptor(IMethodMapping binding) {
        if (binding.getMappingKind() == 102) {
            ICallinMapping callinMapping = (ICallinMapping)binding;
            switch (callinMapping.getCallinKind()) {
                case 1: {
                    return ImageManager.getSharedInstance().getDescriptor("callinbindingbefore_obj.gif");
                }
                case 2: {
                    return ImageManager.getSharedInstance().getDescriptor("callinbindingafter_obj.gif");
                }
            }
            return ImageManager.getSharedInstance().getDescriptor("callinbindingreplace_obj.gif");
        }
        return ImageManager.getSharedInstance().getDescriptor("calloutbinding_obj.gif");
    }
}

