/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: OWLBaseSwitch.java,v 1.1 2007/03/18 08:10:13 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.owl.owlbase.*;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfbase.RDFStatement;
import org.eclipse.eodm.rdf.rdfs.RDFSClass;



/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage
 * @generated
 */
public class OWLBaseSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static OWLBasePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OWLBaseSwitch() {
		if (modelPackage == null) {
			modelPackage = OWLBasePackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case OWLBasePackage.OWL_ONTOLOGY: {
				OWLOntology owlOntology = (OWLOntology)theEObject;
				Object result = caseOWLOntology(owlOntology);
				if (result == null) result = caseRDFSResource(owlOntology);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_GRAPH: {
				OWLGraph owlGraph = (OWLGraph)theEObject;
				Object result = caseOWLGraph(owlGraph);
				if (result == null) result = caseGraph(owlGraph);
				if (result == null) result = caseRDFSResource(owlGraph);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.STATEMENT: {
				Statement statement = (Statement)theEObject;
				Object result = caseStatement(statement);
				if (result == null) result = caseRDFStatement(statement);
				if (result == null) result = caseRDFSResource(statement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.UNIVERSE: {
				Universe universe = (Universe)theEObject;
				Object result = caseUniverse(universe);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_ONTOLOGY_PROPERTY: {
				OWLOntologyProperty owlOntologyProperty = (OWLOntologyProperty)theEObject;
				Object result = caseOWLOntologyProperty(owlOntologyProperty);
				if (result == null) result = caseRDFProperty(owlOntologyProperty);
				if (result == null) result = caseUniverse(owlOntologyProperty);
				if (result == null) result = caseRDFSResource(owlOntologyProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_CLASS: {
				OWLClass owlClass = (OWLClass)theEObject;
				Object result = caseOWLClass(owlClass);
				if (result == null) result = caseRDFSClass(owlClass);
				if (result == null) result = caseUniverse(owlClass);
				if (result == null) result = caseRDFSResource(owlClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_RESTRICTION: {
				OWLRestriction owlRestriction = (OWLRestriction)theEObject;
				Object result = caseOWLRestriction(owlRestriction);
				if (result == null) result = caseOWLClass(owlRestriction);
				if (result == null) result = caseRDFSClass(owlRestriction);
				if (result == null) result = caseUniverse(owlRestriction);
				if (result == null) result = caseRDFSResource(owlRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_OBJECT_PROPERTY: {
				OWLObjectProperty owlObjectProperty = (OWLObjectProperty)theEObject;
				Object result = caseOWLObjectProperty(owlObjectProperty);
				if (result == null) result = caseProperty(owlObjectProperty);
				if (result == null) result = caseRDFProperty(owlObjectProperty);
				if (result == null) result = caseUniverse(owlObjectProperty);
				if (result == null) result = caseRDFSResource(owlObjectProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.PROPERTY: {
				Property property = (Property)theEObject;
				Object result = caseProperty(property);
				if (result == null) result = caseRDFProperty(property);
				if (result == null) result = caseUniverse(property);
				if (result == null) result = caseRDFSResource(property);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_DATATYPE_PROPERTY: {
				OWLDatatypeProperty owlDatatypeProperty = (OWLDatatypeProperty)theEObject;
				Object result = caseOWLDatatypeProperty(owlDatatypeProperty);
				if (result == null) result = caseProperty(owlDatatypeProperty);
				if (result == null) result = caseRDFProperty(owlDatatypeProperty);
				if (result == null) result = caseUniverse(owlDatatypeProperty);
				if (result == null) result = caseRDFSResource(owlDatatypeProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.INDIVIDUAL: {
				Individual individual = (Individual)theEObject;
				Object result = caseIndividual(individual);
				if (result == null) result = caseRDFSResource(individual);
				if (result == null) result = caseUniverse(individual);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_ALL_DIFFERENT: {
				OWLAllDifferent owlAllDifferent = (OWLAllDifferent)theEObject;
				Object result = caseOWLAllDifferent(owlAllDifferent);
				if (result == null) result = caseOWLClass(owlAllDifferent);
				if (result == null) result = caseRDFSClass(owlAllDifferent);
				if (result == null) result = caseUniverse(owlAllDifferent);
				if (result == null) result = caseRDFSResource(owlAllDifferent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_DATA_RANGE: {
				OWLDataRange owlDataRange = (OWLDataRange)theEObject;
				Object result = caseOWLDataRange(owlDataRange);
				if (result == null) result = caseRDFSClass(owlDataRange);
				if (result == null) result = caseUniverse(owlDataRange);
				if (result == null) result = caseRDFSResource(owlDataRange);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.OWL_ANNOTATION_PROPERTY: {
				OWLAnnotationProperty owlAnnotationProperty = (OWLAnnotationProperty)theEObject;
				Object result = caseOWLAnnotationProperty(owlAnnotationProperty);
				if (result == null) result = caseRDFProperty(owlAnnotationProperty);
				if (result == null) result = caseUniverse(owlAnnotationProperty);
				if (result == null) result = caseRDFSResource(owlAnnotationProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.ENUMERATED_CLASS: {
				EnumeratedClass enumeratedClass = (EnumeratedClass)theEObject;
				Object result = caseEnumeratedClass(enumeratedClass);
				if (result == null) result = caseOWLClass(enumeratedClass);
				if (result == null) result = caseRDFSClass(enumeratedClass);
				if (result == null) result = caseUniverse(enumeratedClass);
				if (result == null) result = caseRDFSResource(enumeratedClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.INTERSECTION_CLASS: {
				IntersectionClass intersectionClass = (IntersectionClass)theEObject;
				Object result = caseIntersectionClass(intersectionClass);
				if (result == null) result = caseOWLClass(intersectionClass);
				if (result == null) result = caseRDFSClass(intersectionClass);
				if (result == null) result = caseUniverse(intersectionClass);
				if (result == null) result = caseRDFSResource(intersectionClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.UNION_CLASS: {
				UnionClass unionClass = (UnionClass)theEObject;
				Object result = caseUnionClass(unionClass);
				if (result == null) result = caseOWLClass(unionClass);
				if (result == null) result = caseRDFSClass(unionClass);
				if (result == null) result = caseUniverse(unionClass);
				if (result == null) result = caseRDFSResource(unionClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.COMPLEMENT_CLASS: {
				ComplementClass complementClass = (ComplementClass)theEObject;
				Object result = caseComplementClass(complementClass);
				if (result == null) result = caseOWLClass(complementClass);
				if (result == null) result = caseRDFSClass(complementClass);
				if (result == null) result = caseUniverse(complementClass);
				if (result == null) result = caseRDFSResource(complementClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.HAS_VALUE_RESTRICTION: {
				HasValueRestriction hasValueRestriction = (HasValueRestriction)theEObject;
				Object result = caseHasValueRestriction(hasValueRestriction);
				if (result == null) result = caseOWLRestriction(hasValueRestriction);
				if (result == null) result = caseOWLClass(hasValueRestriction);
				if (result == null) result = caseRDFSClass(hasValueRestriction);
				if (result == null) result = caseUniverse(hasValueRestriction);
				if (result == null) result = caseRDFSResource(hasValueRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.ALL_VALUES_FROM_RESTRICTION: {
				AllValuesFromRestriction allValuesFromRestriction = (AllValuesFromRestriction)theEObject;
				Object result = caseAllValuesFromRestriction(allValuesFromRestriction);
				if (result == null) result = caseOWLRestriction(allValuesFromRestriction);
				if (result == null) result = caseOWLClass(allValuesFromRestriction);
				if (result == null) result = caseRDFSClass(allValuesFromRestriction);
				if (result == null) result = caseUniverse(allValuesFromRestriction);
				if (result == null) result = caseRDFSResource(allValuesFromRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.SOME_VALUES_FROM_RESTRICTION: {
				SomeValuesFromRestriction someValuesFromRestriction = (SomeValuesFromRestriction)theEObject;
				Object result = caseSomeValuesFromRestriction(someValuesFromRestriction);
				if (result == null) result = caseOWLRestriction(someValuesFromRestriction);
				if (result == null) result = caseOWLClass(someValuesFromRestriction);
				if (result == null) result = caseRDFSClass(someValuesFromRestriction);
				if (result == null) result = caseUniverse(someValuesFromRestriction);
				if (result == null) result = caseRDFSResource(someValuesFromRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.CARDINALITY_RESTRICTION: {
				CardinalityRestriction cardinalityRestriction = (CardinalityRestriction)theEObject;
				Object result = caseCardinalityRestriction(cardinalityRestriction);
				if (result == null) result = caseOWLRestriction(cardinalityRestriction);
				if (result == null) result = caseOWLClass(cardinalityRestriction);
				if (result == null) result = caseRDFSClass(cardinalityRestriction);
				if (result == null) result = caseUniverse(cardinalityRestriction);
				if (result == null) result = caseRDFSResource(cardinalityRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.MAX_CARDINALITY_RESTRICTION: {
				MaxCardinalityRestriction maxCardinalityRestriction = (MaxCardinalityRestriction)theEObject;
				Object result = caseMaxCardinalityRestriction(maxCardinalityRestriction);
				if (result == null) result = caseOWLRestriction(maxCardinalityRestriction);
				if (result == null) result = caseOWLClass(maxCardinalityRestriction);
				if (result == null) result = caseRDFSClass(maxCardinalityRestriction);
				if (result == null) result = caseUniverse(maxCardinalityRestriction);
				if (result == null) result = caseRDFSResource(maxCardinalityRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case OWLBasePackage.MIN_CARDINALITY_RESTRICTION: {
				MinCardinalityRestriction minCardinalityRestriction = (MinCardinalityRestriction)theEObject;
				Object result = caseMinCardinalityRestriction(minCardinalityRestriction);
				if (result == null) result = caseOWLRestriction(minCardinalityRestriction);
				if (result == null) result = caseOWLClass(minCardinalityRestriction);
				if (result == null) result = caseRDFSClass(minCardinalityRestriction);
				if (result == null) result = caseUniverse(minCardinalityRestriction);
				if (result == null) result = caseRDFSResource(minCardinalityRestriction);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Ontology</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Ontology</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLOntology(OWLOntology object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Graph</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Graph</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLGraph(OWLGraph object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Statement</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseStatement(Statement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Universe</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Universe</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseUniverse(Universe object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Ontology Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Ontology Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLOntologyProperty(OWLOntologyProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLClass(OWLClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLRestriction(OWLRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Object Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Object Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLObjectProperty(OWLObjectProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseProperty(Property object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Datatype Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Datatype Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLDatatypeProperty(OWLDatatypeProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Individual</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Individual</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseIndividual(Individual object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL All Different</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL All Different</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLAllDifferent(OWLAllDifferent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Data Range</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Data Range</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLDataRange(OWLDataRange object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>OWL Annotation Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>OWL Annotation Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOWLAnnotationProperty(OWLAnnotationProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Enumerated Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Enumerated Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseEnumeratedClass(EnumeratedClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Intersection Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Intersection Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseIntersectionClass(IntersectionClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Union Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Union Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseUnionClass(UnionClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Complement Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Complement Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseComplementClass(ComplementClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Has Value Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Has Value Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseHasValueRestriction(HasValueRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>All Values From Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>All Values From Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAllValuesFromRestriction(AllValuesFromRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Some Values From Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Some Values From Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSomeValuesFromRestriction(SomeValuesFromRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Cardinality Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Cardinality Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCardinalityRestriction(CardinalityRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Max Cardinality Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Max Cardinality Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseMaxCardinalityRestriction(MaxCardinalityRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Min Cardinality Restriction</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Min Cardinality Restriction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseMinCardinalityRestriction(MinCardinalityRestriction object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSResource(RDFSResource object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFGraph</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFGraph</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseGraph(RDFGraph object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Statement</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Statement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFStatement(RDFStatement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFProperty(RDFProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSClass(RDFSClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //OWLBaseSwitch
