/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.editor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractToggleHandler
extends AbstractHandler {
    private static final String STATE_ID = "org.eclipse.ui.commands.toggleState";
    private final String commandID;
    private State state;

    protected AbstractToggleHandler(String commandID) {
        this.commandID = commandID;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        if (activePage == null || this.state == null) {
            return null;
        }
        boolean current = (Boolean)this.state.getValue();
        this.doToggle(activePage, !current);
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IWorkbenchPage activePage;
        super.setEnabled(evaluationContext);
        IWorkbenchWindow activeWindow = (IWorkbenchWindow)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeWorkbenchWindow");
        IWorkbenchPage iWorkbenchPage = activePage = activeWindow == null ? null : activeWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        ICommandService commandService = (ICommandService)activeWindow.getService(ICommandService.class);
        Command command = commandService.getCommand(this.commandID);
        if (this.state == null) {
            State state;
            State state2 = state = command == null ? null : command.getState(STATE_ID);
            if (state == null) {
                return;
            }
            this.state = state;
            boolean fromState = (Boolean)state.getValue();
            boolean initial = this.initializeFromState(activePage, fromState);
            state.setValue((Object)initial);
        } else {
            this.state.setValue((Object)this.updateState(activePage));
        }
    }

    protected abstract void doToggle(IWorkbenchPage var1, boolean var2);

    protected abstract boolean updateState(IWorkbenchPage var1);

    protected boolean initializeFromState(IWorkbenchPage page, boolean on) {
        return on;
    }
}

