/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.command.RowInsertCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;

public class RowInsertCommandHandler<T>
implements ILayerCommandHandler<RowInsertCommand> {
    private List<T> bodyData;

    public RowInsertCommandHandler(List<T> bodyData) {
        this.bodyData = bodyData;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, RowInsertCommand command) {
        if (command.convertToTargetLayer(targetLayer)) {
            if (command.getRowIndex() < 0 || command.getRowIndex() >= this.bodyData.size()) {
                this.bodyData.addAll(command.getObjects());
                targetLayer.fireLayerEvent(new RowInsertEvent(targetLayer, new Range(this.bodyData.size() - command.getObjects().size(), this.bodyData.size())));
            } else {
                this.bodyData.addAll(command.getRowIndex(), command.getObjects());
                targetLayer.fireLayerEvent(new RowInsertEvent(targetLayer, new Range(command.getRowIndex(), command.getRowIndex() + command.getObjects().size())));
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<RowInsertCommand> getCommandClass() {
        return RowInsertCommand.class;
    }
}

