/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

public class DuplicateDiagramCommand
extends DuplicateEObjectsCommand {
    private final Diagram diagramToDuplicate;

    public DuplicateDiagramCommand(TransactionalEditingDomain editingDomain, String label, Diagram diagram) {
        super(editingDomain, label, Collections.singletonList(diagram));
        this.diagramToDuplicate = diagram;
    }

    public DuplicateDiagramCommand(TransactionalEditingDomain editingDomain, String label, Diagram diagram, Map allDuplicatedObjectsMap) {
        super(editingDomain, label, Collections.singletonList(diagram), allDuplicatedObjectsMap);
        this.diagramToDuplicate = diagram;
    }

    public DuplicateDiagramCommand(TransactionalEditingDomain editingDomain, String label, Diagram diagram, Map allDuplicatedObjectsMap, EObject targetContainer) {
        super(editingDomain, label, Collections.singletonList(diagram), allDuplicatedObjectsMap, targetContainer);
        this.diagramToDuplicate = diagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        DiagramCopier copier = new DiagramCopier(this.getAllDuplicatedObjectsMap());
        copier.copy((EObject)this.diagramToDuplicate);
        copier.copyReferences();
        EObject duplicateDiagram = (EObject)copier.get(this.diagramToDuplicate);
        Resource targetResource = this.getNotationResourceForDiagram(((Diagram)duplicateDiagram).getElement(), this.getEditingDomain());
        if (targetResource != null) {
            targetResource.getContents().add((Object)duplicateDiagram);
        } else {
            Activator.log.warn("It was not possible to find the Resource with the target EObject");
            targetResource = this.diagramToDuplicate.eResource();
            if (targetResource != null) {
                Activator.log.error("It was not possible to find the Resource with the source diagram", null);
                targetResource.getContents().add((Object)duplicateDiagram);
            }
        }
        return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
    }

    public boolean canExecute() {
        return true;
    }

    public Resource getNotationResourceForDiagram(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "notation", true);
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public Resource getDiResourceForDiagram(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "di", true);
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    protected class DiagramCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = 8544123249170461708L;
        private Map<EObject, EObject> semanticObjects;

        public DiagramCopier(Map<EObject, EObject> semanticObjects) {
            this.semanticObjects = semanticObjects;
        }

        public EObject get(Object arg0) {
            EObject object = (EObject)super.get(arg0);
            if (object == null) {
                object = this.semanticObjects.get(arg0);
            }
            return object;
        }
    }
}

