/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter;

import ca.odell.glazedlists.matchers.Matcher;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.papyrus.infra.nattable.filter.AbstractPapyrusMatcherEditor;
import org.eclipse.papyrus.infra.nattable.filter.AbstractSinglePapyrusMatcher;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;

public class BooleanMatcherEditor
extends AbstractPapyrusMatcherEditor {
    public BooleanMatcherEditor(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        super(columnAccesor, columnIndex, matchOn, configRegistry);
    }

    @Override
    protected Matcher<Object> createMatcher(IColumnAccessor<Object> columnAccesor, int columnIndex, Object matchOn, IConfigRegistry configRegistry) {
        return new BooleanMatcher(columnAccesor, matchOn, columnIndex);
    }

    public static class BooleanMatcher
    extends AbstractSinglePapyrusMatcher<Object> {
        public BooleanMatcher(IColumnAccessor<Object> accessor, Object wantedObject, int columnIndex) {
            super(accessor, columnIndex, wantedObject);
            Assert.isTrue((!(wantedObject instanceof Collection) ? 1 : 0) != 0);
            Assert.isTrue((wantedObject instanceof Boolean || wantedObject.equals(CellHelper.getUnsupportedCellContentsText()) ? 1 : 0) != 0);
        }

        public boolean matches(Object item) {
            Object wantedValue = this.getObjectToMatch();
            Object value = this.getCellValueFor(item);
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                return coll.contains(wantedValue);
            }
            return this.getObjectToMatch().equals(value);
        }
    }
}

