/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.core.resource.PapyrusProjectScope;
import org.eclipse.papyrus.infra.internationalization.common.IPreferenceStoreListener;
import org.eclipse.papyrus.infra.ui.preferences.PapyrusScopedPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

class PreferenceStoreManager
extends AbstractUIPlugin {
    static final String INTERNATIONALIZATION_NODE_LABEL = "internationalization";
    private final Map<ScopeKey, IPreferenceStore> preferenceStores = new HashMap<ScopeKey, IPreferenceStore>();
    private final CopyOnWriteArrayList<IPreferenceStoreListener> preferenceStoreListeners = new CopyOnWriteArrayList();
    private final LogHelper log;

    PreferenceStoreManager(LogHelper log) {
        this.log = log;
    }

    public void dispose() {
        this.disposePreferenceStores();
        this.preferenceStoreListeners.clear();
    }

    public IPreferenceStore getInternationalizationPreferenceStore(IProject project, String papyrusProjectName) {
        ScopeKey key = new ScopeKey(project, papyrusProjectName);
        IPreferenceStore result = this.preferenceStores.get(key);
        if (result == null) {
            PapyrusProjectScope scope = new PapyrusProjectScope(project, papyrusProjectName);
            result = new PapyrusScopedPreferenceStore((IScopeContext)scope, INTERNATIONALIZATION_NODE_LABEL);
            this.preferenceStores.put(new ScopeKey(project, papyrusProjectName), result);
            this.created(project, papyrusProjectName, result);
        }
        return result;
    }

    public IPreferenceStore getInternationalizationPreferenceStore() {
        IPreferenceStore result = this.preferenceStores.get(ScopeKey.INSTANCE_SCOPE);
        if (result == null) {
            IScopeContext scope = InstanceScope.INSTANCE;
            result = new ScopedPreferenceStore(scope, this.getBundle().getSymbolicName());
            this.preferenceStores.put(ScopeKey.INSTANCE_SCOPE, result);
        }
        return result;
    }

    void addPreferenceStoreListener(IPreferenceStoreListener listener) {
        if (this.preferenceStoreListeners.addIfAbsent(listener)) {
            this.added(listener);
        }
    }

    void removePreferenceStoreListener(IPreferenceStoreListener listener) {
        this.preferenceStoreListeners.remove(listener);
    }

    private void added(IPreferenceStoreListener listener) {
        if (this.hasProjectPreferences()) {
            for (Map.Entry<ScopeKey, IPreferenceStore> next : this.preferenceStores.entrySet()) {
                ScopeKey key = next.getKey();
                if (!key.isProjectScope()) continue;
                try {
                    listener.preferenceStoreCreated(key.getProject(), key.getPapyrusProject(), next.getValue());
                }
                catch (Exception e) {
                    this.log.error("Uncaught exception in preference store listener.", (Throwable)e);
                }
            }
        }
    }

    private void created(IProject project, String papyrusProject, IPreferenceStore store) {
        if (!this.preferenceStoreListeners.isEmpty()) {
            for (IPreferenceStoreListener next : this.preferenceStoreListeners) {
                try {
                    next.preferenceStoreCreated(project, papyrusProject, store);
                }
                catch (Exception e) {
                    this.log.error("Uncaught exception in preference store listener.", (Throwable)e);
                }
            }
        }
    }

    private boolean hasProjectPreferences() {
        return !this.preferenceStores.isEmpty() && !this.preferenceStores.keySet().equals(Collections.singleton(ScopeKey.INSTANCE_SCOPE));
    }

    private void disposePreferenceStores() {
        for (Map.Entry<ScopeKey, IPreferenceStore> next : this.preferenceStores.entrySet()) {
            ScopeKey key = next.getKey();
            if (!key.isProjectScope()) continue;
            this.disposed(key.getProject(), key.getPapyrusProject(), next.getValue());
        }
        this.preferenceStores.clear();
    }

    private void disposed(IProject project, String papyrusProject, IPreferenceStore store) {
        if (!this.preferenceStoreListeners.isEmpty()) {
            for (IPreferenceStoreListener next : this.preferenceStoreListeners) {
                try {
                    next.preferenceStoreDisposed(project, papyrusProject, store);
                }
                catch (Exception e) {
                    this.log.error("Uncaught exception in preference store listener.", (Throwable)e);
                }
            }
        }
    }

    private static final class ScopeKey {
        static final ScopeKey INSTANCE_SCOPE = new ScopeKey(null, null);
        private final IProject project;
        private final String papyrusProject;

        ScopeKey(IProject project, String papyrusProject) {
            if (project == null && INSTANCE_SCOPE != null) {
                throw new NullPointerException("project");
            }
            if (papyrusProject == null && project != null) {
                throw new NullPointerException("papyrusProject");
            }
            this.project = project;
            this.papyrusProject = papyrusProject;
        }

        IProject getProject() {
            return this.project;
        }

        String getPapyrusProject() {
            return this.papyrusProject;
        }

        boolean isProjectScope() {
            return this.project != null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.papyrusProject == null ? 0 : this.papyrusProject.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScopeKey other = (ScopeKey)obj;
            if (this.papyrusProject == null ? other.papyrusProject != null : !this.papyrusProject.equals(other.papyrusProject)) {
                return false;
            }
            return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
        }
    }
}

