/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.PositionUtils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.Node;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.Comment;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.CommentsCollection;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.CommentsParser;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.LineComment;

public class CommentsInserter {
    private boolean doNotAssignCommentsPreceedingEmptyLines = true;
    private boolean doNotConsiderAnnotationsAsNodeStartForCodeAttribution = false;

    public void insertComments(CompilationUnit cu, String code) throws IOException {
        CommentsParser commentsParser = new CommentsParser();
        CommentsCollection allComments = commentsParser.parse(code);
        this.insertCommentsInCu(cu, allComments);
    }

    public boolean getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution() {
        return this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public void setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(boolean doNotConsiderAnnotationsAsNodeStartForCodeAttribution) {
        this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution = doNotConsiderAnnotationsAsNodeStartForCodeAttribution;
    }

    public boolean getDoNotAssignCommentsPreceedingEmptyLines() {
        return this.doNotAssignCommentsPreceedingEmptyLines;
    }

    public void setDoNotAssignCommentsPreceedingEmptyLines(boolean doNotAssignCommentsPreceedingEmptyLines) {
        this.doNotAssignCommentsPreceedingEmptyLines = doNotAssignCommentsPreceedingEmptyLines;
    }

    private void insertCommentsInCu(CompilationUnit cu, CommentsCollection commentsCollection) {
        if (commentsCollection.size() == 0) {
            return;
        }
        List<Comment> comments = commentsCollection.getAll();
        PositionUtils.sortByBeginPosition(comments);
        List<Node> children = cu.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        if (cu.getPackage() != null && (children.size() == 0 || PositionUtils.areInOrder(comments.get(0), children.get(0)))) {
            cu.setComment(comments.get(0));
            comments.remove(0);
        }
        this.insertCommentsInNode(cu, comments);
    }

    private void insertCommentsInNode(Node node, List<Comment> commentsToAttribute) {
        if (commentsToAttribute.size() == 0) {
            return;
        }
        List<Node> children = node.getChildrenNodes();
        PositionUtils.sortByBeginPosition(children);
        for (Node child : children) {
            LinkedList commentsInsideChild = new LinkedList();
            for (Comment c : commentsToAttribute) {
                if (!PositionUtils.nodeContains(child, c, this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution)) continue;
                commentsInsideChild.add(c);
            }
            commentsToAttribute.removeAll(commentsInsideChild);
            this.insertCommentsInNode(child, commentsInsideChild);
        }
        LinkedList<Comment> attributedComments = new LinkedList<Comment>();
        for (Comment comment : commentsToAttribute) {
            if (!comment.isLineComment()) continue;
            for (Node child : children) {
                if (child.getEndLine() != comment.getBeginLine() || !this.attributeLineCommentToNodeOrChild(child, comment.asLineComment())) continue;
                attributedComments.add(comment);
            }
        }
        Comment previousComment = null;
        attributedComments = new LinkedList();
        LinkedList<Node> childrenAndComments = new LinkedList<Node>();
        childrenAndComments.addAll(children);
        childrenAndComments.addAll(commentsToAttribute);
        PositionUtils.sortByBeginPosition(childrenAndComments, this.doNotConsiderAnnotationsAsNodeStartForCodeAttribution);
        for (Node thing : childrenAndComments) {
            if (thing instanceof Comment) {
                previousComment = (Comment)thing;
                if (previousComment.isOrphan()) continue;
                previousComment = null;
                continue;
            }
            if (previousComment == null || thing.hasComment() || this.doNotAssignCommentsPreceedingEmptyLines && this.thereAreLinesBetween(previousComment, thing)) continue;
            thing.setComment(previousComment);
            attributedComments.add(previousComment);
            previousComment = null;
        }
        commentsToAttribute.removeAll(attributedComments);
        for (Comment c : commentsToAttribute) {
            if (!c.isOrphan()) continue;
            node.addOrphanComment(c);
        }
    }

    private boolean attributeLineCommentToNodeOrChild(Node node, LineComment lineComment) {
        if (node.getBeginLine() == lineComment.getBeginLine() && !node.hasComment()) {
            node.setComment(lineComment);
            return true;
        }
        LinkedList<Node> children = new LinkedList<Node>();
        children.addAll(node.getChildrenNodes());
        PositionUtils.sortByBeginPosition(children);
        Collections.reverse(children);
        for (Node child : children) {
            if (!this.attributeLineCommentToNodeOrChild(child, lineComment)) continue;
            return true;
        }
        return false;
    }

    private boolean thereAreLinesBetween(Node a, Node b) {
        if (!PositionUtils.areInOrder(a, b)) {
            return this.thereAreLinesBetween(b, a);
        }
        int endOfA = a.getEndLine();
        return b.getBeginLine() > endOfA + 1;
    }
}

