/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtend.typesystem.emf.EcoreUtil2;

public class UML2Util2 {
    private static final Map<URI, Profile> profiles = new HashMap<URI, Profile>();

    public static final Profile loadProfile(String pathToProfile) {
        if (UML2Util2.isBlank(pathToProfile)) {
            throw new RuntimeException("No profile specified. Check the configuration.");
        }
        URI uri = EcoreUtil2.getURI((String)pathToProfile);
        if (uri == null) {
            throw new RuntimeException("cannot resolve Profile for " + pathToProfile + ". Probably cannot find the .profile.uml2 file.");
        }
        return UML2Util2.loadProfile(uri);
    }

    public static final synchronized Profile loadProfile(URI uri) {
        if (profiles.containsKey(uri)) {
            return profiles.get(uri);
        }
        Resource r = new ResourceSetImpl().createResource(uri);
        try {
            r.load(new HashMap());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        EList c = r.getContents();
        if (c.isEmpty()) {
            return null;
        }
        if (c.get(0) instanceof Profile) {
            Profile p = (Profile)c.get(0);
            profiles.put(uri, p);
            return p;
        }
        return null;
    }

    public static String getXmiId(Element obj) {
        return obj.eResource() != null && obj.eResource() instanceof XMLResource ? ((XMLResource)obj.eResource()).getID((EObject)obj) : null;
    }

    private static boolean isBlank(String string) {
        return string == null || string.trim().equals("");
    }
}

