/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.Iterator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public class AcceleoRemoveAnnotationJob
extends Job {
    private AcceleoEditor acceleoEditor;

    public AcceleoRemoveAnnotationJob(AcceleoEditor editor) {
        super(AcceleoUIMessages.getString("AcceleoRemoveAnnotationJob.Name"));
        this.acceleoEditor = editor;
        this.setSystem(true);
        this.setPriority(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IAnnotationModel model;
        if (this.acceleoEditor != null && (model = this.acceleoEditor.getDocumentProvider().getAnnotationModel((Object)this.acceleoEditor.getEditorInput())) != null) {
            Object object = this.getLockObject(model);
            synchronized (object) {
                Iterator annotations = model.getAnnotationIterator();
                while (annotations.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Annotation annotation = (Annotation)annotations.next();
                    if (!"org.eclipse.jdt.ui.occurrences".equals(annotation.getType())) continue;
                    model.removeAnnotation(annotation);
                }
                this.acceleoEditor.offsetASTNodeURI = "";
            }
        }
        return Status.OK_STATUS;
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected void canceling() {
        this.acceleoEditor = null;
        super.canceling();
    }

    public void clear() {
        this.acceleoEditor = null;
    }
}

