/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.wizards.module.example.IAcceleoInitializationStrategy;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelFactory;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.ModuleElementKind;
import org.eclipse.acceleo.internal.ide.ui.generators.AcceleoUIGenerator;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.example.AcceleoInitializationStrategyUtils;
import org.eclipse.acceleo.internal.ide.ui.wizards.project.AcceleoModulesCreationPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AcceleoProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String MODULE_NAME_PREFIX = "org.eclipse.acceleo.module.";
    public static final String INITIAL_PROJECT_NAME = "org.eclipse.acceleo.module.sample";
    private static final String RESOURCE_WORKING_SET_ID = "org.eclipse.ui.resourceWorkingSetPage";
    private static final String JAVA_WORKING_SET_ID = "org.eclipse.jdt.ui.JavaWorkingSetPage";
    protected IConfigurationElement configurationElement;
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected WizardNewProjectCreationPage newProjectPage;
    protected AcceleoModulesCreationPage newAcceleoModulesCreationPage;
    private String container;

    public AcceleoProjectWizard() {
        this.setWindowTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iSelection) {
        this.workbench = iWorkbench;
        this.selection = iSelection;
    }

    public void addPages() {
        String newProjectWizardName = AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Name");
        this.newProjectPage = new WizardNewProjectCreationPage(newProjectWizardName){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.createWorkingSetGroup((Composite)this.getControl(), AcceleoProjectWizard.this.getSelection(), new String[]{AcceleoProjectWizard.RESOURCE_WORKING_SET_ID, AcceleoProjectWizard.JAVA_WORKING_SET_ID});
                Dialog.applyDialogFont((Control)this.getControl());
            }
        };
        this.newProjectPage.setInitialProjectName(INITIAL_PROJECT_NAME);
        this.newProjectPage.setTitle(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Title"));
        this.newProjectPage.setDescription(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Page.Description"));
        this.newProjectPage.setImageDescriptor(AcceleoUIActivator.getImageDescriptor("icons/AcceleoWizard.gif"));
        this.addPage((IWizardPage)this.newProjectPage);
        this.newAcceleoModulesCreationPage = new AcceleoModulesCreationPage();
        this.addPage((IWizardPage)this.newAcceleoModulesCreationPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewProjectCreationPage) {
            WizardNewProjectCreationPage newPage = (WizardNewProjectCreationPage)page;
            this.container = newPage.getProjectName();
            this.container = String.valueOf(this.container) + "/src/" + this.container.replaceAll("\\.", "/");
            this.container = String.valueOf(this.container) + "/common";
            this.newAcceleoModulesCreationPage.setContainer(this.container);
        }
        return super.getNextPage(page);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }

    public boolean canFinish() {
        IWizardContainer iWizardContainer = this.getContainer();
        IWizardPage currentPage = iWizardContainer.getCurrentPage();
        if (currentPage instanceof WizardNewProjectCreationPage) {
            return this.newProjectPage.isPageComplete();
        }
        return this.newProjectPage.isPageComplete() && this.newAcceleoModulesCreationPage.isPageComplete();
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean performFinish() {
        try {
            IWizardContainer iWizardContainer = this.getContainer();
            IRunnableWithProgress projectCreation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(AcceleoProjectWizard.this.newProjectPage.getProjectName());
                        IPath location = AcceleoProjectWizard.this.newProjectPage.getLocationPath();
                        if (!project.exists()) {
                            IProjectDescription desc = project.getWorkspace().newProjectDescription(AcceleoProjectWizard.this.newProjectPage.getProjectName());
                            if (ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)location)) {
                                location = null;
                            }
                            desc.setLocation(location);
                            project.create(desc, monitor);
                            project.open(monitor);
                            AcceleoProjectWizard.this.convert(project, AcceleoProjectWizard.this, monitor);
                        }
                    }
                    catch (CoreException e) {
                        AcceleoUIActivator.log((Exception)((Object)e), true);
                    }
                }
            };
            iWizardContainer.run(false, false, projectCreation);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
            return true;
        }
        catch (InvocationTargetException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (InterruptedException e) {
            AcceleoUIActivator.log(e, true);
        }
        return false;
    }

    private void convert(IProject project, AcceleoProjectWizard wizard, IProgressMonitor monitor) {
        IFolder antTasksFolder;
        String projectName = wizard.newProjectPage.getProjectName();
        String generatorName = this.computeGeneratorName(projectName);
        AcceleoProject acceleoProject = AcceleowizardmodelFactory.eINSTANCE.createAcceleoProject();
        acceleoProject.setName(projectName);
        acceleoProject.setGeneratorName(generatorName);
        List<AcceleoModule> allModules = this.newAcceleoModulesCreationPage.getAllModules();
        IWizardContainer iWizardContainer = this.getContainer();
        IWizardPage currentPage = iWizardContainer.getCurrentPage();
        if (!(currentPage instanceof WizardNewProjectCreationPage)) {
            for (AcceleoModule acceleoModule : allModules) {
                String parentFolder = acceleoModule.getParentFolder();
                IProject moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(acceleoModule.getProjectName());
                if (!moduleProject.exists() || !moduleProject.isAccessible() || acceleoModule.getModuleElement() == null || !acceleoModule.getModuleElement().isIsMain()) continue;
                Path parentFolderPath = new Path(parentFolder);
                IFolder folder = moduleProject.getFolder(parentFolderPath.removeFirstSegments(1));
                acceleoProject.getExportedPackages().add((Object)folder.getProjectRelativePath().removeFirstSegments(1).toString().replaceAll("/", "\\."));
            }
        }
        if (!(antTasksFolder = project.getFolder("tasks")).exists()) {
            try {
                antTasksFolder.create(true, false, monitor);
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
        }
        try {
            IProjectDescription description = project.getDescription();
            String[] natureIds = new String[]{"org.eclipse.acceleo.ide.ui.acceleoNature", "org.eclipse.pde.PluginNature", "org.eclipse.jdt.core.javanature"};
            description.setNatureIds(natureIds);
            project.setDescription(description, monitor);
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
        monitor.beginTask(AcceleoUIMessages.getString("AcceleoNewProjectWizard.Monitor"), 100);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateProjectSettings(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateProjectClasspath(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateProjectManifest(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateBuildProperties(acceleoProject, (IContainer)project);
        monitor.worked(10);
        AcceleoUIGenerator.getDefault().generateActivator(acceleoProject, (IContainer)project);
        if (currentPage instanceof WizardNewProjectCreationPage) {
            return;
        }
        for (AcceleoModule acceleoModule : allModules) {
            monitor.worked(10);
            String parentFolder = acceleoModule.getParentFolder();
            IProject moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(acceleoModule.getProjectName());
            if (!moduleProject.exists() || !moduleProject.isAccessible()) continue;
            Path parentFolderPath = new Path(parentFolder);
            IFolder folder = moduleProject.getFolder(parentFolderPath.removeFirstSegments(1));
            AcceleoUIGenerator.getDefault().generateAcceleoModule(acceleoModule, (IContainer)folder);
            if (!acceleoModule.isIsInitialized()) continue;
            String initializationKind = acceleoModule.getInitializationKind();
            IAcceleoInitializationStrategy strategy = null;
            List<IAcceleoInitializationStrategy> initializationStrategy = AcceleoInitializationStrategyUtils.getInitializationStrategy();
            for (IAcceleoInitializationStrategy iAcceleoInitializationStrategy : initializationStrategy) {
                if (iAcceleoInitializationStrategy.getDescription() == null || !iAcceleoInitializationStrategy.getDescription().equals(initializationKind)) continue;
                strategy = iAcceleoInitializationStrategy;
                break;
            }
            IFile file = folder.getFile(String.valueOf(acceleoModule.getName()) + "." + "mtl");
            IFile exampleFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(acceleoModule.getInitializationPath()));
            String moduleElementKind = "template";
            if (acceleoModule.getModuleElement().getKind().equals((Object)ModuleElementKind.QUERY)) {
                moduleElementKind = "query";
            }
            if (strategy == null || !file.exists()) continue;
            try {
                strategy.configure(moduleElementKind, acceleoModule.getModuleElement().isGenerateFile(), acceleoModule.getModuleElement().isIsMain(), acceleoModule.isGenerateDocumentation());
                String content = strategy.getContent(exampleFile, acceleoModule.getName(), (List<String>)acceleoModule.getMetamodelURIs(), acceleoModule.getModuleElement().getParameterType());
                ByteArrayInputStream javaStream = new ByteArrayInputStream(content.getBytes("UTF8"));
                file.setContents((InputStream)javaStream, true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                AcceleoUIActivator.log((Exception)((Object)e), true);
            }
            catch (UnsupportedEncodingException e) {
                AcceleoUIActivator.log(e, true);
            }
        }
    }

    private String computeGeneratorName(String projectName) {
        String generatorName = projectName;
        if (generatorName.startsWith(MODULE_NAME_PREFIX)) {
            generatorName = generatorName.substring(MODULE_NAME_PREFIX.length());
        } else {
            int i = generatorName.lastIndexOf(46);
            if (i > -1) {
                generatorName = generatorName.substring(i + 1);
            }
        }
        if (generatorName.length() > 0) {
            StringTokenizer st = new StringTokenizer(generatorName, ".");
            generatorName = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() <= 0) continue;
                generatorName = String.valueOf(generatorName) + Character.toUpperCase(token.charAt(0)) + token.substring(1);
            }
        }
        return generatorName;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }
}

