/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColorManager;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoToken;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.swt.graphics.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAcceleoScanner
extends RuleBasedScanner {
    private final IEclipsePreferences[] lookupOrder;
    private IRule[] rules;

    public AbstractAcceleoScanner(IEclipsePreferences[] lookupOrder) {
        if (lookupOrder != null && lookupOrder.length > 0) {
            this.lookupOrder = lookupOrder;
        } else {
            IEclipsePreferences defaultScope = new DefaultScope().getNode("org.eclipse.acceleo.ide.ui");
            IEclipsePreferences instanceScope = new InstanceScope().getNode("org.eclipse.acceleo.ide.ui");
            this.lookupOrder = new IEclipsePreferences[]{instanceScope, defaultScope};
        }
        this.createRules();
    }

    protected IEclipsePreferences[] getLookupOrder() {
        return this.lookupOrder;
    }

    protected Color getColor(AcceleoColor color) {
        return AcceleoColorManager.getColor(color, this.getLookupOrder());
    }

    public void setRules(IRule[] rules) {
        super.setRules(rules);
        this.rules = rules;
    }

    protected AcceleoToken createToken(AcceleoColor foreground) {
        Color swtForeground = this.getColor(foreground);
        TextAttribute tokenData = new TextAttribute(swtForeground);
        return new AcceleoToken(tokenData, foreground.getPreferenceKey());
    }

    protected AcceleoToken createToken(AcceleoColor foreground, AcceleoColor background, int style) {
        Color swtForeground = this.getColor(foreground);
        Color swtBackground = null;
        if (background != null) {
            swtBackground = this.getColor(background);
        }
        TextAttribute tokenData = new TextAttribute(swtForeground, swtBackground, style);
        return new AcceleoToken(tokenData, foreground.getPreferenceKey());
    }

    protected abstract void createRules();

    public abstract String getConfiguredContentType();

    public List<AcceleoToken> getAffectedToken(String preferenceKey) {
        ArrayList<AcceleoToken> affectedTokens = new ArrayList<AcceleoToken>();
        if (preferenceKey == null || "".equals(preferenceKey)) {
            return affectedTokens;
        }
        IRule[] iRuleArray = this.rules;
        int n = this.rules.length;
        int n2 = 0;
        while (n2 < n) {
            String tokenKey;
            IToken token;
            IRule rule = iRuleArray[n2];
            if (rule instanceof IPredicateRule && (token = ((IPredicateRule)rule).getSuccessToken()) instanceof AcceleoToken && (tokenKey = ((AcceleoToken)token).getColorKey()) != null && tokenKey.equals(preferenceKey)) {
                affectedTokens.add((AcceleoToken)token);
            }
            ++n2;
        }
        return affectedTokens;
    }
}

