/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.utils;

import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaServicesUtils {
    private JavaServicesUtils() {
    }

    public static String createQuery(Method javaMethod) {
        StringBuilder buffer = new StringBuilder();
        Class<?>[] javaParameters = javaMethod.getParameterTypes();
        buffer.append("[query public ");
        buffer.append(javaMethod.getName());
        buffer.append("(");
        int i = 0;
        while (i < javaParameters.length) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append("arg");
            buffer.append(i);
            buffer.append(" : ");
            buffer.append(JavaServicesUtils.javaClass2OclType(javaParameters[i]));
            ++i;
        }
        buffer.append(") : ");
        buffer.append(JavaServicesUtils.javaClass2OclType(javaMethod.getReturnType()));
        buffer.append("\n\t= invoke('");
        buffer.append(javaMethod.getDeclaringClass().getName());
        buffer.append("', '");
        buffer.append(javaMethod.getName());
        buffer.append("(");
        i = 0;
        while (i < javaParameters.length) {
            if (i > 0) {
                buffer.append(',');
                buffer.append(' ');
            }
            buffer.append(javaParameters[i].getName());
            ++i;
        }
        buffer.append(")', Sequence{");
        i = 0;
        while (i < javaParameters.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("arg");
            buffer.append(i);
            ++i;
        }
        buffer.append("}) /]\n\n");
        return buffer.toString();
    }

    private static String javaClass2OclType(Class<?> javaClass) {
        String result;
        if (javaClass != null && javaClass.getName() != null) {
            String type = javaClass.getName();
            if ("java.math.BigDecimal".equals(type) || "java.lang.Double".equals(type) || "double".equals(type)) {
                result = "Real";
            } else if ("java.math.BigInteger".equals(type) || "java.lang.Integer".equals(type) || "int".equals(type)) {
                result = "Integer";
            } else if ("java.lang.Short".equals(type) || "short".equals(type)) {
                result = "Integer";
            } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
                result = "Boolean";
            } else if ("java.lang.String".equals(type)) {
                result = "String";
            } else if ("java.util.List".equals(type) || "java.util.ArrayList".equals(type) || "java.util.LinkedList".equals(type)) {
                result = "Sequence(OclAny)";
            } else if ("java.util.Set".equals(type) || "java.util.HashSet".equals(type)) {
                result = "Set(OclAny)";
            } else if ("java.util.LinkedHashSet".equals(type)) {
                result = "OrderedSet(OclAny)";
            } else if ("java.util.Collection".equals(type)) {
                result = "Collection(OclAny)";
            } else if ("java.lang.Object".equals(type)) {
                result = "OclAny";
            } else if ("void".equals(type)) {
                result = "OclVoid";
            } else {
                result = type;
                int lastDot = result.lastIndexOf(46);
                if (lastDot > -1) {
                    result = result.substring(lastDot + 1);
                }
            }
        } else {
            result = "OclVoid";
        }
        return result;
    }
}

