/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.builders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoBuilderUtils {
    private AcceleoBuilderUtils() {
    }

    public static List<Sequence> getImportSequencesToSearch(AcceleoProject acceleoProject, IFile file) {
        ArrayList<Sequence> result = new ArrayList<Sequence>();
        String simpleModuleName = new Path(file.getName()).removeFileExtension().lastSegment();
        String[] tokens = new String[]{"[", "import", simpleModuleName};
        result.add(new Sequence(tokens));
        tokens = new String[]{"extends", simpleModuleName};
        result.add(new Sequence(tokens));
        String javaPackageName = acceleoProject.getPackageName(file);
        String fullModuleName = AcceleoFile.javaPackageToFullModuleName((String)javaPackageName, (String)simpleModuleName);
        tokens = new String[]{"[", "import", fullModuleName};
        result.add(new Sequence(tokens));
        tokens = new String[]{"extends", fullModuleName};
        result.add(new Sequence(tokens));
        return result;
    }

    public static void members(List<IFile> filesOutput, IContainer container, String extension, IPath outputFolder) throws CoreException {
        IResource[] children;
        if (container != null && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile && extension.equals(((IFile)resource).getFileExtension())) {
                    filesOutput.add((IFile)resource);
                } else if (resource instanceof IContainer && (outputFolder == null || !outputFolder.isPrefixOf(resource.getFullPath()))) {
                    AcceleoBuilderUtils.members(filesOutput, (IContainer)resource, extension, outputFolder);
                }
                ++i;
            }
        }
    }
}

