/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.compare.tests.edit.data.ecore.a1.EcoreA1InputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMatchTreeNodeItemProviderSpec
extends AbstractTestTreeNodeItemProviderAdapter {
    private static TreeNodeItemProviderSpec itemProvider;
    static Predicate<Object> matchTreeNode;

    static {
        matchTreeNode = new Predicate<Object>(){

            public boolean apply(Object object) {
                EObject data;
                return object instanceof TreeNode && (data = ((TreeNode)object).getData()) instanceof Match;
            }
        };
    }

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
    }

    @Test
    public void testGetChildren_EcoreA1() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackageMatchChildren = ePackageMatch.getChildren();
        Assert.assertEquals((long)10L, (long)ePackageMatchChildren.size());
        Assert.assertTrue((boolean)Iterables.all((Iterable)ePackageMatchChildren, (Predicate)Predicates.instanceOf(MatchNode.class)));
        Iterable ePackageData = Iterables.transform((Iterable)ePackageMatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)ePackageData, Match.class)));
    }

    static TreeNode getEcoreA1_EPackageMatch() throws IOException {
        Comparison comparison = TestMatchTreeNodeItemProviderSpec.getComparison((ResourceScopeProvider)new EcoreA1InputData());
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }

    @Test
    public void testGetChildren_AudioVisualItem() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackageData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match audioVisualItem_Match = this.getMatchWithFeatureValue(ePackageData, "name", "AudioVisualItem");
        TreeNode audioVisualItem_Match_Node = TestMatchTreeNodeItemProviderSpec.getTreeNode(ePackageMatch, (EObject)audioVisualItem_Match);
        EList audioVisualItem_MatchChildren = audioVisualItem_Match_Node.getChildren();
        Assert.assertEquals((long)3L, (long)audioVisualItem_MatchChildren.size());
        Iterable audioData = Iterables.transform((Iterable)audioVisualItem_MatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioData, Diff.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioData, Match.class)));
    }

    @Test
    public void testGetChildren_AudioVisualItem_length() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackageData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match audioVisualItem_Match = this.getMatchWithFeatureValue(ePackageData, "name", "AudioVisualItem");
        TreeNode audioVisualItem_Match_Node = TestMatchTreeNodeItemProviderSpec.getTreeNode(ePackageMatch, (EObject)audioVisualItem_Match);
        EList audioVisualItem_MatchChildren = audioVisualItem_Match_Node.getChildren();
        Iterable audioData = Iterables.transform((Iterable)audioVisualItem_MatchChildren, (Function)TREE_NODE_DATA);
        Match audioVisualItem_length_Match = this.getMatchWithFeatureValue(audioData, "name", "length");
        TreeNode audioLengthTreeNode = TestMatchTreeNodeItemProviderSpec.getTreeNode(audioVisualItem_Match_Node, (EObject)audioVisualItem_length_Match);
        Collection audioVisualItem_length_MatchChildren = itemProvider.getChildren((Object)audioLengthTreeNode);
        Assert.assertEquals((long)2L, (long)audioVisualItem_length_MatchChildren.size());
        Assert.assertTrue((boolean)Iterables.all((Iterable)audioVisualItem_length_MatchChildren, (Predicate)Predicates.instanceOf(DiffNode.class)));
        Iterable audioLengthData = Iterables.transform((Iterable)audioVisualItem_length_MatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioLengthData, Diff.class)));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioLengthData, Match.class)));
    }

    @Test
    public void testGetChildren_Book() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackage_MatchChildrenData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match book_Match = this.getMatchWithFeatureValue(ePackage_MatchChildrenData, "name", "Book");
        TreeNode book_Match_Node = TestMatchTreeNodeItemProviderSpec.getTreeNode(ePackageMatch, (EObject)book_Match);
        EList book_MatchChildren = book_Match_Node.getChildren();
        Assert.assertEquals((long)3L, (long)book_MatchChildren.size());
        Iterable book_MatchChildrenData = Iterables.transform((Iterable)book_MatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)book_MatchChildrenData, Diff.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)book_MatchChildrenData, Match.class)));
    }

    @Test
    public void testGetChildren_BookCategory() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackage_MatchChildrenData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match bookCategory_Match = this.getMatchWithFeatureValue(ePackage_MatchChildrenData, "name", "BookCategory");
        TreeNode bookCategory_Match_Node = TestMatchTreeNodeItemProviderSpec.getTreeNode(ePackageMatch, (EObject)bookCategory_Match);
        EList bookCategory_MatchChildren = bookCategory_Match_Node.getChildren();
        Assert.assertEquals((long)4L, (long)bookCategory_MatchChildren.size());
        Assert.assertTrue((boolean)Iterables.all((Iterable)bookCategory_MatchChildren, (Predicate)Predicates.instanceOf(MatchNode.class)));
        Iterable bookCategory_MatchChildrenData = Iterables.transform((Iterable)bookCategory_MatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bookCategory_MatchChildrenData, Match.class)));
        for (TreeNode matchNode : bookCategory_MatchChildren) {
            Assert.assertEquals((long)1L, (long)matchNode.getChildren().size());
        }
    }

    @Test
    public void testGetChildren_Borrowable() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackage_MatchChildrenData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match borrowable_Match = this.getMatchWithFeatureValue(ePackage_MatchChildrenData, "name", "Borrowable");
        TreeNode borrowable_Match_Node = TestMatchTreeNodeItemProviderSpec.getTreeNode(ePackageMatch, (EObject)borrowable_Match);
        EList borrowable_MatchChildren = borrowable_Match_Node.getChildren();
        Assert.assertEquals((long)1L, (long)borrowable_MatchChildren.size());
        Iterable borrowable_MatchChildrenData = Iterables.transform((Iterable)borrowable_MatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)borrowable_MatchChildrenData, Diff.class)));
    }

    @Test
    public void testGetChildren_Person() throws IOException {
        TreeNode ePackageMatch = TestMatchTreeNodeItemProviderSpec.getEcoreA1_EPackageMatch();
        EList ePackage_MatchChildren = ePackageMatch.getChildren();
        Iterable ePackage_MatchChildrenData = Iterables.transform((Iterable)ePackage_MatchChildren, (Function)TREE_NODE_DATA);
        Match person_Match = this.getMatchWithFeatureValue(ePackage_MatchChildrenData, "name", "Person");
        TreeNode person_Match_Node = TestMatchTreeNodeItemProviderSpec.getTreeNode(ePackageMatch, (EObject)person_Match);
        EList person_MatchChildren = person_Match_Node.getChildren();
        Assert.assertEquals((long)3L, (long)person_MatchChildren.size());
        Iterable person_MatchChildrenData = Iterables.transform((Iterable)person_MatchChildren, (Function)TREE_NODE_DATA);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)person_MatchChildrenData, Match.class)));
    }
}

