/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.tests.groups;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.postprocessor.BasicPostProcessorDescriptorImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.TechnicalitiesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.compare.uml2.internal.postprocessor.UMLPostProcessor;
import org.eclipse.emf.compare.uml2.internal.provider.custom.UMLCompareCustomItemProviderAdapterFactory;
import org.eclipse.emf.compare.uml2.internal.provider.decorator.UMLCompareItemProviderDecoratorAdapterFactory;
import org.eclipse.emf.compare.uml2.rcp.ui.internal.structuremergeviewer.filters.UMLRefinedElementsFilter;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.AbstractDifferenceOrderTest;
import org.eclipse.emf.compare.uml2.rcp.ui.tests.groups.NotifierScopeProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class UMLDifferencesOrderTest
extends AbstractDifferenceOrderTest {
    private ExpectedResultData expectedResult;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.getFilter().removeFilter((IDifferenceFilter)new CascadingDifferencesFilter());
        this.getFilter().removeFilter((IDifferenceFilter)new TechnicalitiesFilter());
        this.expectedResult = new ExpectedResultData();
    }

    @Override
    protected NotifierScopeProvider getInput() {
        return new DataInput();
    }

    @Override
    protected List<AdapterFactory> getAdaptersFactory() {
        this.eventBus = new EventBus();
        return Lists.newArrayList((Object[])new AdapterFactory[]{new CompareItemProviderAdapterFactorySpec(), new TreeItemProviderAdapterFactorySpec(new StructureMergeViewerFilter(this.eventBus)), new UMLCompareCustomItemProviderAdapterFactory(), new UMLItemProviderAdapterFactory(), new UMLCompareItemProviderDecoratorAdapterFactory(), new ReflectiveItemProviderAdapterFactory()});
    }

    @Override
    protected IPostProcessor.Descriptor.Registry<?> getPostProcessorRegistry() {
        PostProcessorDescriptorRegistryImpl postProcessorRegistry = new PostProcessorDescriptorRegistryImpl();
        BasicPostProcessorDescriptorImpl descriptor = new BasicPostProcessorDescriptorImpl((IPostProcessor)new UMLPostProcessor(), Pattern.compile("http://www.eclipse.org/uml2/\\d.0.0/UML"), null);
        postProcessorRegistry.put((Object)UMLPostProcessor.class.getName(), (IPostProcessor.Descriptor)descriptor);
        return postProcessorRegistry;
    }

    @Ignore(value="Refining diffs are displayed inside refined diffs in an order that's not stable.")
    @Test
    public void testDiffOrder() throws IOException {
        UMLRefinedElementsFilter umlRefineFilter = new UMLRefinedElementsFilter();
        this.getFilter().removeFilter((IDifferenceFilter)umlRefineFilter);
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(this.getComparison(), Predicates.alwaysTrue(), this.getCrossReferenceAdapter());
        List roots = group.getChildren();
        this.compareTree(this.expectedResult.getExpectedResultWithoutFilter(), roots, false);
    }

    @Test
    public void testDiffOrderWithUMLRefineFilter() throws IOException {
        UMLRefinedElementsFilter umlRefineFilter = new UMLRefinedElementsFilter();
        this.getFilter().addFilter((IDifferenceFilter)umlRefineFilter);
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(this.getComparison(), Predicates.alwaysTrue(), this.getCrossReferenceAdapter());
        List roots = group.getChildren();
        this.compareTree(this.expectedResult.getExpectedResultWithFilter(), roots, false);
    }

    private static class DataInput
    extends AbstractInputData
    implements NotifierScopeProvider {
        private DataInput() {
        }

        public Resource getLeft() throws IOException {
            return this.loadFromClassLoader("data/a1/left.uml");
        }

        public Resource getOrigin() throws IOException {
            return this.loadFromClassLoader("data/a1/origin.uml");
        }

        public Resource getRight() throws IOException {
            return this.loadFromClassLoader("data/a1/right.uml");
        }
    }

    private static class ExpectedResultData
    extends AbstractInputData {
        private ExpectedResultData() {
        }

        public Resource getExpectedResultWithoutFilter() throws IOException {
            return this.loadFromClassLoader("data/a1/expectedResultWithoutUMLRefineElementFilter.nodes");
        }

        public Resource getExpectedResultWithFilter() throws IOException {
            return this.loadFromClassLoader("data/a1/expectedResultWithUMLRefineElementFilter.nodes");
        }
    }
}

