/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Transformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.AbstractPartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.ActualPartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractTransformationAnalysis
extends AbstractPartialRegionsAnalysis<RegionsAnalysis> {
    protected final @NonNull Transformation transformation;
    protected final @NonNull RootRegion rootRegion;
    protected final @NonNull Property oclContainerProperty;
    private @Nullable CyclicRegionsAnalysis cyclesRegionAnalysis = null;
    private @Nullable Transformation2TracePackage transformation2tracePackage = null;
    private final @NonNull Map<@NonNull Rule, @NonNull RuleAnalysis> rule2ruleAnalysis = new HashMap<Rule, RuleAnalysis>();
    private @NonNull Map<@NonNull Region, @NonNull RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Property, @NonNull List<@NonNull Region>> corollaryProperty2regions = new HashMap<Property, List<Region>>();
    private @Nullable RootPartitionAnalysis rootPartitionAnalysis = null;

    protected AbstractTransformationAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull Transformation transformation, @NonNull Iterable<@NonNull Rule> rules, @NonNull RootRegion rootRegion) {
        super(scheduleManager);
        this.transformation = transformation;
        this.rootRegion = rootRegion;
        this.oclContainerProperty = scheduleManager.getStandardLibraryHelper().getOclContainerProperty();
        for (Rule asRule : rules) {
            RuleAnalysis ruleAnalysis = scheduleManager.createRuleAnalysis(this, asRule);
            this.rule2ruleAnalysis.put(asRule, ruleAnalysis);
        }
    }

    public void addCorollary(@NonNull NavigationEdge edge) {
        assert (edge.isRealized());
        assert (!edge.isNullable());
        Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
        assert (targetNode.isRealized());
        Region region = QVTscheduleUtil.getOwningRegion((ConnectionEnd)edge);
        Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)edge);
        List<@NonNull Region> regions = this.corollaryProperty2regions.get(property);
        if (regions == null) {
            regions = new ArrayList<Region>();
            this.corollaryProperty2regions.put(property, regions);
        }
        if (!regions.contains(region)) {
            regions.add(region);
        }
    }

    public void analyzeMappingRegions() {
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)this.transformation)) {
            RuleAnalysis ruleAnalysis = this.basicGetRuleAnalysis(asRule);
            if (ruleAnalysis == null) continue;
            ruleAnalysis.analyzeMappingRegion();
        }
        CompleteModel completeModel = this.environmentFactory.getCompleteModel();
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)this.transformation)) {
            for (Package asPackage : QVTbaseUtil.getUsedPackages((TypedModel)typedModel)) {
                CompletePackage completePackage = completeModel.getCompletePackage(asPackage);
                this.scheduleManager.analyzeCompletePackage(typedModel, completePackage);
            }
        }
    }

    public void analyzeSourceModel(@NonNull ProblemHandler problemHandler) {
        Collection<@NonNull RuleAnalysis> ruleAnalyses = this.rule2ruleAnalysis.values();
        for (RuleAnalysis ruleAnalysis : ruleAnalyses) {
            ruleAnalysis.analyzeOverrides(problemHandler);
        }
        for (RuleAnalysis ruleAnalysis : ruleAnalyses) {
            ruleAnalysis.analyzeInvocations(problemHandler);
        }
        for (RuleAnalysis ruleAnalysis : ruleAnalyses) {
            ruleAnalysis.analyzeSourceModel(problemHandler);
        }
    }

    public @Nullable RegionAnalysis basicGetRegionAnalysis(@NonNull Region region) {
        return this.region2regionAnalysis.get(region);
    }

    public @Nullable RootPartitionAnalysis basicGetRootPartitionAnalysis() {
        return this.rootPartitionAnalysis;
    }

    public @Nullable RuleAnalysis basicGetRuleAnalysis(@NonNull Rule rule) {
        return this.rule2ruleAnalysis.get(rule);
    }

    public @Nullable CyclicRegionAnalysis basicGetCyclicRegionAnalysis(@NonNull RegionAnalysis regionAnalysis) {
        assert (this.cyclesRegionAnalysis != null);
        return this.cyclesRegionAnalysis.basicGetCyclicRegionAnalysis(regionAnalysis);
    }

    @Override
    public @Nullable ActualPartialRegionPropertyAnalysis<@NonNull RegionsAnalysis> basicGetPropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        assert (QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum) != this.oclContainerProperty);
        return super.basicGetPropertyAnalysis(propertyDatum);
    }

    protected void computeCyclicRegionsAnalysis(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        this.cyclesRegionAnalysis = new CyclicRegionsAnalysis(regionAnalyses);
    }

    @Override
    protected @NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis> createClassAnalysis(@NonNull ClassDatum classDatum) {
        return new TraceClassRegionAnalysis(this, classDatum);
    }

    public @NonNull Iterable<@NonNull RuleRegion> gatherRuleRegions() {
        ArrayList<@NonNull RuleRegion> ruleRegions = new ArrayList<RuleRegion>();
        this.gatherRuleRegions(ruleRegions);
        Collections.sort(ruleRegions, NameUtil.NAMEABLE_COMPARATOR);
        return ruleRegions;
    }

    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        for (RuleAnalysis ruleAnalysis : this.rule2ruleAnalysis.values()) {
            ruleAnalysis.gatherRuleRegions(ruleRegions);
        }
    }

    public @Nullable List<@NonNull Region> getCorollaryOf(@NonNull NavigationEdge edge) {
        return this.corollaryProperty2regions.get(QVTscheduleUtil.getReferredProperty((NavigationEdge)edge));
    }

    public String getName() {
        return this.transformation.getName();
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = new RegionAnalysis(this, region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull RootPartitionAnalysis getRootPartitionAnalysis() {
        return (RootPartitionAnalysis)ClassUtil.nonNullState((Object)this.rootPartitionAnalysis);
    }

    public @NonNull RuleAnalysis getRuleAnalysis(@NonNull Rule rule) {
        return (RuleAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)this.rule2ruleAnalysis.get(rule))));
    }

    public @NonNull RootRegion getRootRegion() {
        return this.rootRegion;
    }

    @Override
    public @NonNull ActualPartialRegionPropertyAnalysis<@NonNull RegionsAnalysis> getPropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        assert (QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum) != this.oclContainerProperty);
        return super.getPropertyAnalysis(propertyDatum);
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull Transformation2TracePackage getTransformation2TracePackage() {
        Transformation2TracePackage transformation2tracePackage2 = this.transformation2tracePackage;
        if (transformation2tracePackage2 == null) {
            this.transformation2tracePackage = transformation2tracePackage2 = this.scheduleManager.getTransformation2TracePackage(this.transformation);
        }
        return transformation2tracePackage2;
    }

    public boolean isCorollary(@NonNull NavigationEdge navigationEdge) {
        List<@NonNull Region> corollaryOf = this.getCorollaryOf(navigationEdge);
        return corollaryOf != null;
    }

    public boolean isCorollary(@NonNull Node node) {
        block3: {
            block2: {
                if (!node.isPredicated()) break block2;
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    List<Region> corollaryOf;
                    NavigationEdge navigationEdge;
                    if (!edge.isPredicated() || !(edge instanceof NavigationEdge) || (navigationEdge = (NavigationEdge)edge).isSecondary() || (corollaryOf = this.getCorollaryOf(navigationEdge)) == null) continue;
                    return true;
                }
                break block3;
            }
            if (!node.isRealized()) break block3;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                List<Region> corollaryOf;
                NavigationEdge navigationEdge;
                if (!edge.isRealized() || !(edge instanceof NavigationEdge) || (navigationEdge = (NavigationEdge)edge).isSecondary() || (corollaryOf = this.getCorollaryOf(navigationEdge)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic(@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis> classAnalysis) {
        assert (this.cyclesRegionAnalysis != null);
        return this.cyclesRegionAnalysis.isCyclic(classAnalysis);
    }

    public boolean isCyclic(@NonNull ClassDatum classDatum) {
        PartialRegionClassAnalysis<@NonNull PRA> classAnalysis = this.basicGetClassAnalysis(classDatum);
        if (classAnalysis == null) {
            return false;
        }
        return classAnalysis.isCyclic();
    }

    public @NonNull PartitionedTransformationAnalysis partition(@NonNull ProblemHandler problemHandler, @NonNull Iterable<? extends @NonNull Region> activeRegions) throws CompilerChainException {
        assert (this.rootPartitionAnalysis == null);
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = TransformationPartitioner.partition(this, problemHandler, activeRegions);
        this.rootPartitionAnalysis = partitionedTransformationAnalysis.getRootPartitionAnalysis();
        return partitionedTransformationAnalysis;
    }

    public void prePartition() throws CompilerChainException {
        if (this.scheduleManager.needsDiscrimination()) {
            this.computeTraceClassDiscrimination();
        }
        this.computeTraceClassInheritance();
        this.computeCyclicRegionsAnalysis(this.region2regionAnalysis.values());
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }
}

