/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.EntryPointsAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelsManager;

public class TypedModelAnalysis {
    protected final @NonNull EntryPointsAnalysis entryPointsAnalysis;
    protected final @NonNull TypedModel typedModel;
    protected final @NonNull Set<@NonNull CompleteClass> allInstancesCompleteClasses;
    protected final @NonNull Map<@NonNull CompleteClass, @Nullable List<@NonNull CompleteClass>> instancesCompleteClassAnalysis;
    protected final @NonNull Map<@NonNull CompleteClass, @NonNull Integer> instancesCompleteClass2index;
    protected final @NonNull List<@NonNull CompleteClass> sortedCompleteClasses;
    protected final int extentClassIndex;
    protected @Nullable List<@NonNull Integer> extentOppositePropertyIndexes = null;

    public TypedModelAnalysis(@NonNull EntryPointsAnalysis entryPointsAnalysis, @NonNull TypedModel typedModel, @NonNull Set<@NonNull CompleteClass> allInstancesCompleteClasses) {
        this.entryPointsAnalysis = entryPointsAnalysis;
        this.typedModel = typedModel;
        this.allInstancesCompleteClasses = allInstancesCompleteClasses;
        this.instancesCompleteClassAnalysis = entryPointsAnalysis.getInstancesCompleteClassAnalysis(allInstancesCompleteClasses);
        this.instancesCompleteClass2index = new HashMap<CompleteClass, Integer>(this.instancesCompleteClassAnalysis.size());
        this.sortedCompleteClasses = new ArrayList<CompleteClass>(this.instancesCompleteClassAnalysis.keySet());
        Collections.sort(this.sortedCompleteClasses, NameUtil.NameableComparator.INSTANCE);
        ClassId extentClassId = QVTiModelsManager.EXTENT_CLASSID;
        int extentClassIndex = -1;
        int i = 0;
        while (i < this.sortedCompleteClasses.size()) {
            CompleteClass sortedCompleteClass = this.sortedCompleteClasses.get(i);
            this.instancesCompleteClass2index.put(sortedCompleteClass, i);
            TypeId typeId = sortedCompleteClass.getPrimaryClass().getTypeId();
            if (typeId == extentClassId) {
                extentClassIndex = i;
            }
            ++i;
        }
        this.extentClassIndex = extentClassIndex;
        Map<@NonNull Property, @NonNull Integer> opposites = entryPointsAnalysis.getCaches();
        for (Property property : opposites.keySet()) {
            Class owningClass = PivotUtil.getOwningClass((Property)property);
            TypeId typeId = owningClass.getTypeId();
            if (typeId != extentClassId) continue;
            Integer index = opposites.get(property);
            assert (index != null);
            List<@NonNull Integer> extentOppositePropertyIndexes2 = this.extentOppositePropertyIndexes;
            if (extentOppositePropertyIndexes2 == null) {
                this.extentOppositePropertyIndexes = extentOppositePropertyIndexes2 = new ArrayList<Integer>();
            }
            extentOppositePropertyIndexes2.add(index);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public int @Nullable [] @NonNull [] getClassIndex2allClassIndexes() {
        int iMax = this.sortedCompleteClasses.size();
        int @NonNull [][] classIndex2allClassIndexes = new int[iMax][];
        int i = 0;
        while (i < iMax) {
            CompleteClass instancesClass = this.sortedCompleteClasses.get(i);
            @NonNull List superInstancesClasses = (List)ClassUtil.nonNullState(this.instancesCompleteClassAnalysis.get(instancesClass));
            int j = 0;
            int[] row = new int[superInstancesClasses.size()];
            for (CompleteClass superInstancesClass : superInstancesClasses) {
                Integer index = this.instancesCompleteClass2index.get(superInstancesClass);
                assert (index != null);
                row[j++] = index;
            }
            classIndex2allClassIndexes[i] = row;
            ++i;
        }
        return classIndex2allClassIndexes;
    }

    public @NonNull ClassId @NonNull [] getClassIndex2ClassId() {
        @NonNull ClassId[] classIndex2ClassId = new ClassId[this.sortedCompleteClasses.size()];
        int i = 0;
        while (i < this.sortedCompleteClasses.size()) {
            CompleteClass instancesClass = this.sortedCompleteClasses.get(i);
            TypeId classId = instancesClass.getPrimaryClass().getTypeId();
            classIndex2ClassId[i] = (ClassId)classId;
            ++i;
        }
        return classIndex2ClassId;
    }

    public int getExtentClassIndex() {
        return this.extentClassIndex;
    }

    public @Nullable List<@NonNull Integer> getExtentOppositePropertyIndexes() {
        return this.extentOppositePropertyIndexes;
    }

    public String toString() {
        return this.typedModel.toString();
    }
}

