/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.callhierarchy;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyContentProvider;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyLabelProvider;
import org.eclipse.lsp4e.callhierarchy.CallHierarchyViewTreeNode;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class CallHierarchyViewContentTest
extends AbstractTestWithProject {
    @Override
    @BeforeEach
    public void setUpProject(TestInfo testInfo) throws Exception {
        super.setUpProject(testInfo);
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            caps.setCallHierarchyProvider(Boolean.TRUE);
            return caps;
        });
    }

    @Test
    public void testCallHierarchyShowsCalleeAndCaller() throws Exception {
        IProject p = this.project;
        IFile file = TestUtils.createUniqueTestFile(p, "// mock content for call hierarchy\nfunction f(){}\n");
        IEditorPart editor = TestUtils.openEditor(file);
        IDocument document = LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput());
        Assertions.assertTrue((document != null ? 1 : 0) != 0);
        Shell shell = new Shell(editor.getSite().getShell());
        shell.setLayout((Layout)new FillLayout());
        TreeViewer viewer = new TreeViewer((Composite)shell);
        viewer.setContentProvider((IContentProvider)new CallHierarchyContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new CallHierarchyLabelProvider()));
        shell.open();
        viewer.setInput((Object)new HierarchyViewInput(document, 0));
        TestUtils.waitForAndAssertCondition(5000, shell.getDisplay(), () -> {
            Tree tree = viewer.getTree();
            if (tree.getItemCount() == 0) {
                return false;
            }
            Object data = tree.getItem(0).getData();
            return data instanceof CallHierarchyViewTreeNode;
        });
        Tree tree = viewer.getTree();
        TreeItem root = tree.getItem(0);
        Object rootData = root.getData();
        Assertions.assertInstanceOf(CallHierarchyViewTreeNode.class, (Object)rootData, (String)"Expected CallHierarchyViewTreeNode root");
        CallHierarchyViewTreeNode rootNode = (CallHierarchyViewTreeNode)rootData;
        Assertions.assertEquals((Object)"callee", (Object)rootNode.getCallContainer().getName());
        viewer.expandToLevel(2);
        TestUtils.waitForAndAssertCondition(5000, shell.getDisplay(), () -> root.getItemCount() > 0 && root.getItem(0).getData() instanceof CallHierarchyViewTreeNode);
        Object childData = root.getItem(0).getData();
        Assertions.assertTrue((boolean)(childData instanceof CallHierarchyViewTreeNode));
        CallHierarchyViewTreeNode childNode = (CallHierarchyViewTreeNode)childData;
        Assertions.assertEquals((Object)"caller", (Object)childNode.getCallContainer().getName());
        shell.close();
    }
}

