/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public final class CompletionProposalTools {
    private CompletionProposalTools() {
    }

    public static String getFilterFromDocument(IDocument document, int cursorOffset, String completionItemFilter, int completionInsertionOffset) throws BadLocationException {
        if (completionInsertionOffset >= cursorOffset) {
            return "";
        }
        int prefixToCursorLength = cursorOffset - completionInsertionOffset;
        String prefixToCursor = document.get(completionInsertionOffset, prefixToCursorLength);
        int i = 0;
        while (i < prefixToCursorLength) {
            if (!CompletionProposalTools.isSubstringFoundOrderedInString(prefixToCursor.substring(prefixToCursorLength - i - 1, prefixToCursorLength), completionItemFilter)) break;
            ++i;
        }
        return prefixToCursor.substring(prefixToCursorLength - i);
    }

    public static boolean isSubstringFoundOrderedInString(String subString, String string) {
        int lastIndex = 0;
        subString = subString.toLowerCase();
        string = string.toLowerCase();
        char[] cArray = subString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            int index = string.indexOf(c.charValue(), lastIndex);
            if (index < 0) {
                return false;
            }
            lastIndex = index + 1;
            ++n2;
        }
        return true;
    }

    public static int getCategoryOfFilterMatch(String documentFilter, String completionFilter) {
        if (documentFilter.isEmpty()) {
            return 5;
        }
        documentFilter = documentFilter.toLowerCase();
        completionFilter = completionFilter.toLowerCase();
        int subIndex = completionFilter.indexOf(documentFilter);
        int topCategory = 5;
        if (subIndex == -1) {
            return CompletionProposalTools.isSubstringFoundOrderedInString(documentFilter, completionFilter) ? 4 : 5;
        }
        int documentFilterLength = documentFilter.length();
        int completionFilterLength = completionFilter.length();
        while (subIndex != -1) {
            topCategory = subIndex > 0 && Character.isLetterOrDigit(completionFilter.charAt(subIndex - 1)) ? Math.min(topCategory, 3) : (subIndex + documentFilterLength < completionFilterLength - 1 && Character.isLetterOrDigit(completionFilter.charAt(subIndex + documentFilterLength + 1)) ? Math.min(topCategory, 2) : 1);
            if (topCategory == 1) break;
            subIndex = completionFilter.indexOf(documentFilter, subIndex + 1);
        }
        return topCategory;
    }

    public static int getScoreOfFilterMatch(String documentFilter, String completionFilter) {
        return CompletionProposalTools.getScoreOfFilterMatchHelper(0, documentFilter.toLowerCase(), completionFilter.toLowerCase());
    }

    private static int getScoreOfFilterMatchHelper(int prefixLength, String documentFilter, String completionFilter) {
        if (documentFilter.isEmpty()) {
            return 0;
        }
        char searchChar = documentFilter.charAt(0);
        int i = completionFilter.indexOf(searchChar);
        if (i == -1) {
            return -1;
        }
        int documentFilterLength = documentFilter.length();
        if (documentFilterLength == 1) {
            return i + prefixLength;
        }
        int bestScore = Integer.MAX_VALUE;
        while (i != -1) {
            int matchLength = CompletionProposalTools.commonPrefixLength(documentFilter, completionFilter.substring(i));
            if (matchLength == documentFilterLength) {
                return i + prefixLength;
            }
            int score = i + CompletionProposalTools.getScoreOfFilterMatchHelper(prefixLength + i + matchLength, documentFilter.substring(matchLength), completionFilter.substring(i + matchLength));
            if (score == i - 1) break;
            bestScore = Math.min(bestScore, score);
            i = completionFilter.indexOf(searchChar, i + 1);
        }
        return prefixLength + bestScore;
    }

    private static int commonPrefixLength(String first, String second) {
        int maxCommonLength = Math.min(first.length(), second.length());
        int i = 0;
        while (i < maxCommonLength) {
            if (first.charAt(i) != second.charAt(i)) break;
            ++i;
        }
        return i;
    }
}

