/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.metamodel.model.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RepositoryKind implements Enumerator
{
    PLATFORM(0, "Platform", "Platform"),
    WORKSPACE(1, "Workspace", "Workspace"),
    PLATFORM_AND_WORKSPACE(2, "PlatformAndWorkspace", "PlatformAndWorkspace"),
    UPDATE_SITE(3, "UpdateSite", "UpdateSite"),
    OTHER(4, "Other", "Other");

    public static final int PLATFORM_VALUE = 0;
    public static final int WORKSPACE_VALUE = 1;
    public static final int PLATFORM_AND_WORKSPACE_VALUE = 2;
    public static final int UPDATE_SITE_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    private static final RepositoryKind[] VALUES_ARRAY;
    public static final List<RepositoryKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RepositoryKind[]{PLATFORM, WORKSPACE, PLATFORM_AND_WORKSPACE, UPDATE_SITE, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RepositoryKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryKind get(int value) {
        switch (value) {
            case 0: {
                return PLATFORM;
            }
            case 1: {
                return WORKSPACE;
            }
            case 2: {
                return PLATFORM_AND_WORKSPACE;
            }
            case 3: {
                return UPDATE_SITE;
            }
            case 4: {
                return OTHER;
            }
        }
        return null;
    }

    private RepositoryKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

