/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;

public class RedundantNullnessTypeAnnotationsFilter {
    private static final IAnnotationBinding[] NO_ANNOTATIONS = new IAnnotationBinding[0];
    private static final EnumSet<ImportRewrite.TypeLocation> NEVER_NULLNESS_LOCATIONS = EnumSet.of(ImportRewrite.TypeLocation.LOCAL_VARIABLE, new ImportRewrite.TypeLocation[]{ImportRewrite.TypeLocation.CAST, ImportRewrite.TypeLocation.EXCEPTION, ImportRewrite.TypeLocation.NEW, ImportRewrite.TypeLocation.INSTANCEOF, ImportRewrite.TypeLocation.RECEIVER});
    private final String fNonNullAnnotationName;
    private final String fNullableAnnotationName;
    private final EnumSet<ImportRewrite.TypeLocation> fNonNullByDefaultLocations;

    public static RedundantNullnessTypeAnnotationsFilter createIfConfigured(ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode root = node.getRoot();
        if (root instanceof CompilationUnit) {
            IJavaProject javaProject;
            CompilationUnit compilationUnit = (CompilationUnit)root;
            IJavaElement javaElement = compilationUnit.getJavaElement();
            IJavaProject iJavaProject = javaProject = javaElement == null ? null : javaElement.getJavaProject();
            if (javaProject != null && "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true))) {
                String nonNullAnnotationName = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nonnull", true);
                String nullableAnnotationName = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullable", true);
                String nonNullByDefaultName = javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nonnullbydefault", true);
                if (nonNullAnnotationName == null || nullableAnnotationName == null || nonNullByDefaultName == null) {
                    return null;
                }
                EnumSet<ImportRewrite.TypeLocation> nonNullByDefaultLocations = RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultLocations(node, nonNullByDefaultName);
                return new RedundantNullnessTypeAnnotationsFilter(nonNullAnnotationName, nullableAnnotationName, nonNullByDefaultLocations);
            }
        }
        return null;
    }

    public static EnumSet<ImportRewrite.TypeLocation> determineNonNullByDefaultLocations(ASTNode astNode, String nonNullByDefaultName) {
        while (astNode != null) {
            IAnnotationBinding annot = RedundantNullnessTypeAnnotationsFilter.getNNBDAnnotation(astNode, nonNullByDefaultName);
            if (annot != null) {
                return RedundantNullnessTypeAnnotationsFilter.determineNNBDValue(annot);
            }
            astNode = astNode.getParent();
        }
        return EnumSet.noneOf(ImportRewrite.TypeLocation.class);
    }

    private static EnumSet<ImportRewrite.TypeLocation> determineNNBDValue(IAnnotationBinding annot) {
        IMemberValuePairBinding[] pairs;
        EnumSet<ImportRewrite.TypeLocation> result = EnumSet.noneOf(ImportRewrite.TypeLocation.class);
        IMemberValuePairBinding[] iMemberValuePairBindingArray = pairs = annot.getAllMemberValuePairs();
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
            if (pair.getKey() == null || pair.getKey().equals("value")) {
                Object value = pair.getValue();
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    int k = 0;
                    while (k < values.length) {
                        if (values[k] instanceof IVariableBinding) {
                            String name = ((IVariableBinding)values[k]).getName();
                            try {
                                result.add(ImportRewrite.TypeLocation.valueOf((String)name));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        ++k;
                    }
                } else if (value instanceof IVariableBinding) {
                    String name = ((IVariableBinding)value).getName();
                    try {
                        result.add(ImportRewrite.TypeLocation.valueOf((String)name));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            ++n2;
        }
        return result;
    }

    private static IAnnotationBinding getNNBDAnnotation(ASTNode astNode, String nonNullByDefaultName) {
        List extendsMods = null;
        switch (astNode.getNodeType()) {
            case 15: {
                IPackageBinding packageBinding;
                PackageDeclaration packageDeclaration = ((CompilationUnit)astNode).getPackage();
                if (packageDeclaration != null && (packageBinding = packageDeclaration.resolveBinding()) != null) {
                    IAnnotationBinding[] iAnnotationBindingArray = packageBinding.getAnnotations();
                    int n = iAnnotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
                        ITypeBinding annotationType = annotationBinding.getAnnotationType();
                        if (annotationType != null && annotationType.getQualifiedName().equals(nonNullByDefaultName)) {
                            return annotationBinding;
                        }
                        ++n2;
                    }
                }
                return null;
            }
            case 23: 
            case 31: 
            case 55: 
            case 71: 
            case 72: 
            case 81: 
            case 82: {
                extendsMods = ((BodyDeclaration)astNode).modifiers();
                break;
            }
            case 60: {
                extendsMods = ((VariableDeclarationStatement)astNode).modifiers();
                break;
            }
            case 58: {
                extendsMods = ((VariableDeclarationExpression)astNode).modifiers();
                break;
            }
            case 44: {
                extendsMods = ((SingleVariableDeclaration)astNode).modifiers();
                break;
            }
            case 59: {
                ASTNode parent = ((VariableDeclarationFragment)astNode).getParent();
                if (!(parent instanceof BodyDeclaration)) break;
                extendsMods = ((BodyDeclaration)parent).modifiers();
                break;
            }
            default: {
                return null;
            }
        }
        if (extendsMods != null) {
            for (IExtendedModifier extMod : extendsMods) {
                ITypeBinding annotationType;
                Annotation annotation;
                IAnnotationBinding annotationBinding;
                if (!extMod.isAnnotation() || (annotationBinding = (annotation = (Annotation)extMod).resolveAnnotationBinding()) == null || (annotationType = annotationBinding.getAnnotationType()) == null || !annotationType.getQualifiedName().equals(nonNullByDefaultName)) continue;
                return annotationBinding;
            }
        }
        return null;
    }

    public RedundantNullnessTypeAnnotationsFilter(String nonNullAnnotationName, String nullableAnnotationName, EnumSet<ImportRewrite.TypeLocation> nonNullByDefaultLocations) {
        this.fNonNullAnnotationName = nonNullAnnotationName;
        this.fNullableAnnotationName = nullableAnnotationName;
        this.fNonNullByDefaultLocations = nonNullByDefaultLocations;
    }

    public IAnnotationBinding[] removeUnwantedTypeAnnotations(IAnnotationBinding[] annotations, ImportRewrite.TypeLocation location, ITypeBinding type) {
        if (location == ImportRewrite.TypeLocation.OTHER) {
            return NO_ANNOTATIONS;
        }
        if (type.isTypeVariable() || type.isWildcardType()) {
            return annotations;
        }
        boolean excludeAllNullAnnotations = NEVER_NULLNESS_LOCATIONS.contains(location);
        if (excludeAllNullAnnotations || this.fNonNullByDefaultLocations.contains(location)) {
            ArrayList<IAnnotationBinding> list = new ArrayList<IAnnotationBinding>(annotations.length);
            IAnnotationBinding[] iAnnotationBindingArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotation = iAnnotationBindingArray[n2];
                ITypeBinding annotationType = annotation.getAnnotationType();
                if (annotationType != null) {
                    if (!(annotationType.getQualifiedName().equals(this.fNonNullAnnotationName) || excludeAllNullAnnotations && annotationType.getQualifiedName().equals(this.fNullableAnnotationName))) {
                        list.add(annotation);
                    }
                } else {
                    list.add(annotation);
                }
                ++n2;
            }
            return list.size() == annotations.length ? annotations : list.toArray(new IAnnotationBinding[list.size()]);
        }
        return annotations;
    }
}

