/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.task.list.items.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.commonmark.ext.task.list.items.TaskListItemMarker;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class TaskListItemHtmlNodeRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;
    private final HtmlWriter html;

    public TaskListItemHtmlNodeRenderer(HtmlNodeRendererContext context) {
        this.context = context;
        this.html = context.getWriter();
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        return Collections.singleton(TaskListItemMarker.class);
    }

    public void render(Node node) {
        if (node instanceof TaskListItemMarker) {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            attributes.put("type", "checkbox");
            attributes.put("disabled", "");
            if (((TaskListItemMarker)node).isChecked()) {
                attributes.put("checked", "");
            }
            this.html.tag("input", this.context.extendAttributes(node, "input", attributes));
            this.html.text(" ");
            this.renderChildren(node);
        }
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

