/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.dialogs;

import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.doc.ContextHelpProvider;
import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.etrice.ui.common.base.dialogs.FilteredContentProposalProvider;
import org.eclipse.etrice.ui.common.base.dialogs.MultiValidator2;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public abstract class AbstractPropertyDialog
extends FormDialog {
    public static final String DIALOG_CONTEXT_ID = "org.eclipse.etrice.ui.common.base.dialogContext";
    private static String PREF_KEY_WIDTH = ".width";
    private static String PREF_KEY_HEIGHT = ".height";
    private static String WIDGET_DATA_KEY_VALSTATUS = "etrice.status";
    private IPreferenceStore preferenceStore;
    private String title;
    private FormToolkit toolkit;
    private DataBindingContext bindingContext;
    private HashMap<ControlDecoration, IObservableValue> decoratorMap = new HashMap();
    private GlobalStatus displayedValidationStatus;
    private Label validationLabel;
    private Label validationText;

    public AbstractPropertyDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
        this.preferenceStore = UIBaseActivator.getDefault().getPreferenceStore();
    }

    protected abstract Image getImage();

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        this.setupUserDialogSize();
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        IContextActivation dca = contextService != null ? contextService.activateContext(DIALOG_CONTEXT_ID) : null;
        try {
            int n = super.open();
            return n;
        }
        finally {
            if (dca != null) {
                contextService.deactivateContext(dca);
            }
        }
    }

    protected void createFormContent(IManagedForm mform) {
        this.toolkit = mform.getToolkit();
        this.bindingContext = new DataBindingContext();
        Form form = mform.getForm().getForm();
        form.setText(this.title);
        form.setImage(this.getImage());
        mform.getToolkit().decorateFormHeading(form);
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        body.setLayoutData((Object)new GridData(768));
        this.validationLabel = this.toolkit.createLabel(body, "", 0);
        this.validationLabel.setText("ERROR:");
        this.validationLabel.setForeground(this.getShell().getDisplay().getSystemColor(3));
        this.validationText = this.toolkit.createLabel(body, "", 0);
        this.validationText.setLayoutData((Object)new GridData(768));
        this.createContent(mform, body, this.bindingContext);
        this.displayedValidationStatus = new GlobalStatus(IStatus.class);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.validationText), (IObservableValue)this.displayedValidationStatus);
        String featureId = this.getFeatureContextHelpId();
        if (ContextHelpProvider.isAvailable((String)featureId)) {
            ContextHelpProvider.setHelp((Control)body, (String)featureId);
            this.setHelpAvailable(true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        Object value = this.displayedValidationStatus.getValue();
        if (value instanceof IStatus) {
            boolean ok = ((IStatus)value).isOK();
            this.updateValidationFeedback(ok);
        }
        return bar;
    }

    protected void setValidationFeedbackOff() {
        if (this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setVisible(false);
        this.validationText.setVisible(false);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(false);
        }
    }

    protected void updateValidationFeedback(boolean ok) {
        if (this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setVisible(!ok);
        this.validationText.setVisible(!ok);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(ok);
        }
    }

    protected void setValidationText(String text) {
        this.validationText.setText(text);
    }

    protected abstract void createContent(IManagedForm var1, Composite var2, DataBindingContext var3);

    protected Text createText(Composite parent, String label, EObject obj, EAttribute att) {
        return this.createText(parent, label, obj, att, null);
    }

    protected Text createText(Composite parent, String label, EObject obj, EAttribute att, IValidator validator) {
        return this.createText(parent, label, obj, att, validator, false);
    }

    protected Text createText(Composite parent, String label, EObject obj, EAttribute att, IValidator validator, boolean multiline) {
        return this.createText(parent, label, obj, (EStructuralFeature)att, validator, null, null, multiline);
    }

    protected Text createText(Composite parent, String label, EObject obj, EStructuralFeature feat, IValidator validator, IConverter s2m, IConverter m2s, boolean multiline) {
        return this.createText(parent, label, obj, feat, validator, null, s2m, m2s, multiline);
    }

    protected Text createText(Composite parent, String label, EObject obj, EStructuralFeature feat, IValidator singleValidator, MultiValidator2 multiValidator, IConverter s2m, IConverter m2s, boolean multiline) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        int style = 2048;
        if (multiline) {
            style |= 0x302;
        }
        Text text = this.toolkit.createText(parent, "", style);
        GridData gd = new GridData(multiline ? 1808 : 768);
        text.setLayoutData((Object)gd);
        UpdateValueStrategy t2m = null;
        UpdateValueStrategy m2t = null;
        if (singleValidator != null || s2m != null || m2s != null) {
            t2m = new UpdateValueStrategy();
            if (s2m != null) {
                t2m.setConverter(s2m);
            }
            if (singleValidator != null) {
                t2m.setAfterConvertValidator(singleValidator);
                t2m.setBeforeSetValidator(singleValidator);
            }
            m2t = new UpdateValueStrategy();
            if (m2s != null) {
                m2t.setConverter(m2s);
            }
            if (singleValidator != null) {
                m2t.setAfterConvertValidator(singleValidator);
                m2t.setBeforeSetValidator(singleValidator);
            }
        }
        Object type = s2m != null ? s2m.getToType() : String.class;
        this.createBinding((Widget)text, obj, feat, type, t2m, m2t, multiValidator);
        return text;
    }

    protected Text createFixedText(Composite parent, String label, String txt, boolean multiline) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        int style = 2048;
        if (multiline) {
            style |= 0x302;
        }
        Text text = this.toolkit.createText(parent, txt, style);
        GridData gd = new GridData(multiline ? 1808 : 768);
        text.setLayoutData((Object)gd);
        text.setEnabled(false);
        return text;
    }

    protected Button createCheck(Composite parent, String label, EObject obj, EAttribute att) {
        return this.createCheck(parent, label, obj, att, null, null);
    }

    protected Button createCheck(Composite parent, String label, EObject obj, EAttribute att, IValidator validator, MultiValidator2 multiValidator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        Button check = this.toolkit.createButton(parent, "", 32);
        check.setLayoutData((Object)new GridData(768));
        UpdateValueStrategy t2m = null;
        UpdateValueStrategy m2t = null;
        if (validator != null) {
            t2m = new UpdateValueStrategy();
            t2m.setAfterConvertValidator(validator);
            t2m.setBeforeSetValidator(validator);
            m2t = new UpdateValueStrategy();
            m2t.setAfterConvertValidator(validator);
            m2t.setBeforeSetValidator(validator);
        }
        this.createBinding((Widget)check, obj, (EStructuralFeature)att, Boolean.class, t2m, m2t, multiValidator);
        return check;
    }

    protected Combo createCombo(Composite parent, String label, EObject obj, Object type, EReference ref, List<? extends EObject> candidates, EAttribute nameAttr) {
        return this.createCombo(parent, label, obj, type, ref, candidates, nameAttr, null, null);
    }

    protected Combo createCombo(Composite parent, String label, EObject obj, Object type, EReference ref, List<? extends EObject> candidates, EAttribute nameAttr, IValidator validator, MultiValidator2 multiValidator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(256));
        combo.setVisibleItemCount(10);
        this.toolkit.adapt((Control)combo, true, true);
        Reference2StringConverter r2s = new Reference2StringConverter(type, nameAttr);
        for (EObject eObject : candidates) {
            combo.add((String)r2s.convert(eObject));
        }
        String2ReferenceConverter string2ReferenceConverter = new String2ReferenceConverter(type, candidates, nameAttr);
        UpdateValueStrategy t2m = new UpdateValueStrategy().setConverter((IConverter)string2ReferenceConverter);
        UpdateValueStrategy m2t = new UpdateValueStrategy().setConverter((IConverter)r2s);
        if (validator != null) {
            t2m.setAfterConvertValidator(validator);
            t2m.setBeforeSetValidator(validator);
            m2t.setAfterConvertValidator(validator);
            m2t.setBeforeSetValidator(validator);
        }
        this.createBinding((Widget)combo, obj, (EStructuralFeature)ref, type, t2m, m2t, multiValidator);
        return combo;
    }

    protected Combo createComboUsingDesc(Composite parent, String label, EObject obj, Object type, EReference ref, List<IEObjectDescription> candidates, IValidator validator) {
        return this.createComboUsingDesc(parent, label, obj, type, ref, candidates, validator, null);
    }

    protected Combo createComboUsingDesc(Composite parent, String label, EObject obj, Object type, EReference ref, List<IEObjectDescription> candidates, IValidator validator, MultiValidator2 multiValidator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        ComboViewer comboViewer = new ComboViewer(parent, 2048);
        Combo combo = comboViewer.getCombo();
        this.toolkit.adapt((Control)comboViewer.getCombo(), true, true);
        combo.setLayoutData((Object)new GridData(256));
        combo.setVisibleItemCount(10);
        DescriptionBased_Reference2StringConverter r2s = new DescriptionBased_Reference2StringConverter(type, candidates);
        for (IEObjectDescription desc : candidates) {
            comboViewer.add((Object)r2s.convert(desc).toString());
        }
        AbstractPropertyDialog.enableContentProposal((Control)combo, combo.getItems());
        DescriptionBased_String2ReferenceConverter s2r = new DescriptionBased_String2ReferenceConverter(type, obj, candidates);
        UpdateValueStrategy t2m = new UpdateValueStrategy().setConverter((IConverter)s2r);
        UpdateValueStrategy m2t = new UpdateValueStrategy().setConverter((IConverter)r2s);
        if (validator != null) {
            t2m.setAfterConvertValidator(validator);
            t2m.setBeforeSetValidator(validator);
            m2t.setAfterConvertValidator(validator);
            m2t.setBeforeSetValidator(validator);
        }
        this.createBinding((Widget)combo, obj, (EStructuralFeature)ref, type, t2m, m2t, multiValidator);
        return combo;
    }

    static void enableContentProposal(Control control, String[] items) {
        Verify.verify((control instanceof Combo || control instanceof Text ? 1 : 0) != 0);
        ControlDecoration deco = new ControlDecoration(control, 17408);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        deco.setDescriptionText("Use CTRL + SPACE to see possible values");
        deco.setImage(image);
        deco.setShowOnlyOnFocus(false);
        control.addPaintListener(e -> {
            if (e.getSource() instanceof Control && !((Control)e.getSource()).isEnabled()) {
                deco.hide();
            }
        });
        FilteredContentProposalProvider proposalProvider = null;
        ContentProposalAdapter proposalAdapter = null;
        KeyStroke keyStroke = KeyStroke.getInstance((int)262144, (int)32);
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            HashSet comboItems = Sets.newHashSet((Object[])combo.getItems());
            combo.addModifyListener(e -> {
                if (comboItems.contains(combo.getText())) {
                    deco.hide();
                } else {
                    deco.show();
                }
            });
            proposalProvider = new FilteredContentProposalProvider(combo.getItems());
            proposalAdapter = new ContentProposalAdapter((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider, keyStroke, null);
        } else if (control instanceof Text) {
            Text text = (Text)control;
            text.addModifyListener(e -> {
                if (text.getText().isEmpty()) {
                    deco.show();
                } else {
                    deco.hide();
                }
            });
            proposalProvider = new FilteredContentProposalProvider(items);
            proposalAdapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, keyStroke, null);
        }
        proposalAdapter.setPropagateKeys(true);
        proposalAdapter.setProposalAcceptanceStyle(2);
    }

    protected Combo createCombo(Composite parent, String label, EObject obj, Object type, EAttribute att, List<? extends Enumerator> choices) {
        return this.createCombo(parent, label, obj, type, att, choices, null, null);
    }

    protected Combo createCombo(Composite parent, String label, EObject obj, Object type, EAttribute att, List<? extends Enumerator> choices, IValidator singleValidator, MultiValidator2 multiValidator) {
        Label l = this.toolkit.createLabel(parent, label, 0);
        l.setLayoutData((Object)new GridData(0));
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(256));
        combo.setVisibleItemCount(10);
        this.toolkit.adapt((Control)combo, true, true);
        for (Enumerator enumerator : choices) {
            combo.add(enumerator.getLiteral());
        }
        UpdateValueStrategy updateValueStrategy = new UpdateValueStrategy().setConverter((IConverter)new String2EnumConverter(type, choices));
        UpdateValueStrategy m2t = new UpdateValueStrategy().setConverter((IConverter)new Enum2StringConverter());
        if (singleValidator != null) {
            updateValueStrategy.setAfterConvertValidator(singleValidator);
            updateValueStrategy.setBeforeSetValidator(singleValidator);
            m2t.setAfterConvertValidator(singleValidator);
            m2t.setBeforeSetValidator(singleValidator);
        }
        this.createBinding((Widget)combo, obj, (EStructuralFeature)att, type, updateValueStrategy, m2t, multiValidator);
        return combo;
    }

    protected void createBinding(Widget widget, EObject obj, EStructuralFeature feature, Object objType, UpdateValueStrategy t2m, UpdateValueStrategy m2t, MultiValidator2 multiValidator) {
        ISWTObservableValue observableWidget = null;
        if (widget instanceof Text || widget instanceof StyledText) {
            observableWidget = WidgetProperties.text((int)24).observe(widget);
        } else if (widget instanceof Button || widget instanceof Combo) {
            observableWidget = WidgetProperties.selection().observe(widget);
        }
        IObservableValue observableObj = EMFProperties.value((EStructuralFeature)feature).observe((Object)obj);
        if (multiValidator != null) {
            WritableValue convertedObservable = new WritableValue(null, objType);
            Binding convertBinding = this.bindingContext.bindValue((IObservableValue)observableWidget, (IObservableValue)convertedObservable, t2m, m2t);
            multiValidator.installValidator(convertBinding, observableObj);
            ArrayList<ValidationStatusProvider> valProviders = new ArrayList<ValidationStatusProvider>();
            valProviders.add((ValidationStatusProvider)convertBinding);
            valProviders.add((ValidationStatusProvider)multiValidator);
            widget.setData(WIDGET_DATA_KEY_VALSTATUS, (Object)this.createAggregateValidationStatus(valProviders));
        } else {
            Binding binding = this.bindingContext.bindValue((IObservableValue)observableWidget, observableObj, t2m, m2t);
            widget.setData(WIDGET_DATA_KEY_VALSTATUS, (Object)binding.getValidationStatus());
        }
    }

    protected ControlDecoration createDecorator(Control ctrl, String message) {
        ControlDecoration controlDecoration = new ControlDecoration(ctrl, 16512);
        controlDecoration.setDescriptionText(message);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        IObservableValue status = this.getObservableStatus((Widget)ctrl);
        if (status != null) {
            this.decoratorMap.put(controlDecoration, status);
        }
        return controlDecoration;
    }

    protected ControlDecoration createInfoDecorator(Control ctrl, String message) {
        ControlDecoration controlDecoration = new ControlDecoration(ctrl, 16512);
        controlDecoration.setDescriptionText(message);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        controlDecoration.setImage(fieldDecoration.getImage());
        return controlDecoration;
    }

    protected IStatus getGlobalValidationStatus() {
        return ValidationStatus.ok();
    }

    public void checkValidation() {
        if (this.displayedValidationStatus != null && !this.displayedValidationStatus.isDisposed()) {
            this.displayedValidationStatus.calculate();
        }
    }

    protected DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    protected IObservableValue getObservableStatus(Widget widget) {
        return (IObservableValue)widget.getData(WIDGET_DATA_KEY_VALSTATUS);
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    private IObservableValue createAggregateValidationStatus(Collection<ValidationStatusProvider> valProvider) {
        WritableList observableStatusProvider = new WritableList(valProvider, ValidationStatusProvider.class);
        return new AggregateValidationStatus((IObservableCollection)observableStatusProvider, 2);
    }

    private void setupUserDialogSize() {
        int width = this.preferenceStore.getInt(String.valueOf(((Object)((Object)this)).getClass().getName()) + PREF_KEY_WIDTH);
        int height = this.preferenceStore.getInt(String.valueOf(((Object)((Object)this)).getClass().getName()) + PREF_KEY_HEIGHT);
        if (width > 0 && height > 0) {
            this.getShell().setSize(width, height);
        }
        this.getShell().addControlListener(new ControlListener(){
            String dialogId;
            {
                this.dialogId = ((Object)((Object)AbstractPropertyDialog.this)).getClass().getName();
            }

            public void controlResized(ControlEvent e) {
                Point size = AbstractPropertyDialog.this.getShell().getSize();
                AbstractPropertyDialog.this.preferenceStore.setValue(String.valueOf(this.dialogId) + PREF_KEY_WIDTH, size.x);
                AbstractPropertyDialog.this.preferenceStore.setValue(String.valueOf(this.dialogId) + PREF_KEY_HEIGHT, size.y);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    protected void setTextSelectionAndFocus(Text text, String selectString) {
        if (selectString.isEmpty()) {
            return;
        }
        String content = text.getText();
        int start = content.indexOf(String.valueOf(selectString) + '(');
        if (start != -1) {
            int end = start + selectString.length() + 1;
            Stack<Character> parenthesis = new Stack<Character>();
            parenthesis.push(Character.valueOf('('));
            while (end < content.length() && !parenthesis.isEmpty()) {
                if (content.charAt(end) == '(') {
                    parenthesis.push(Character.valueOf('('));
                } else if (content.charAt(end) == ')') {
                    parenthesis.pop();
                }
                ++end;
            }
            text.setFocus();
            text.setSelection(start, end);
        }
    }

    protected abstract String getFeatureContextHelpId();

    static class DescriptionBased_Reference2StringConverter
    extends Converter {
        private List<IEObjectDescription> candidates;

        DescriptionBased_Reference2StringConverter(Object type, List<IEObjectDescription> candidates) {
            super(type, String.class);
            this.candidates = candidates;
        }

        public Object convert(Object fromObject) {
            if (fromObject instanceof IEObjectDescription) {
                return ((IEObjectDescription)fromObject).getName();
            }
            if (fromObject instanceof EObject) {
                URI objURI = EcoreUtil.getURI((EObject)((EObject)fromObject));
                Optional<IEObjectDescription> match = this.candidates.stream().filter(eObjDesc -> eObjDesc.getEObjectURI().equals(objURI)).findFirst();
                if (match.isPresent()) {
                    return match.get().getName().toString();
                }
                return SimpleAttributeResolver.NAME_RESOLVER.apply((EObject)fromObject);
            }
            return null;
        }
    }

    static class DescriptionBased_String2ReferenceConverter
    extends Converter {
        private EObject obj;
        private List<IEObjectDescription> candidates;

        DescriptionBased_String2ReferenceConverter(Object type, EObject obj, List<IEObjectDescription> candidates) {
            super(String.class, type);
            this.obj = obj;
            this.candidates = candidates;
        }

        public Object convert(Object fromObject) {
            for (IEObjectDescription desc : this.candidates) {
                if (!desc.getName().toString().equals(fromObject)) continue;
                EObject refObj = desc.getEObjectOrProxy();
                if (refObj.eIsProxy()) {
                    refObj = EcoreUtil.resolve((EObject)refObj, (EObject)this.obj);
                }
                return refObj;
            }
            return null;
        }
    }

    static class Enum2StringConverter
    extends Converter {
        Enum2StringConverter() {
            super(Enumerator.class, String.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject == null) {
                return "";
            }
            return ((Enumerator)fromObject).getLiteral();
        }
    }

    private class GlobalStatus
    extends ComputedValue {
        Collection<ControlDecoration> decorations;

        private GlobalStatus(Object valueType) {
            super(valueType);
            this.decorations = AbstractPropertyDialog.this.decoratorMap.keySet();
        }

        protected Object calculate() {
            boolean ok = true;
            IStatus newStatus = AbstractPropertyDialog.this.getGlobalValidationStatus();
            if (newStatus.getSeverity() > 0 && !newStatus.getMessage().isEmpty()) {
                AbstractPropertyDialog.this.validationText.setText(newStatus.getMessage());
            }
            for (ControlDecoration decoration : this.decorations) {
                IObservableValue observableValue = AbstractPropertyDialog.this.decoratorMap.get(decoration);
                IStatus status = (IStatus)observableValue.getValue();
                if (!status.isOK()) {
                    ok = false;
                    decoration.setDescriptionText(status.getMessage());
                    decoration.show();
                    if (status.getSeverity() <= newStatus.getSeverity() || status.getMessage().isEmpty()) continue;
                    newStatus = status;
                    continue;
                }
                decoration.hide();
            }
            AbstractPropertyDialog.this.updateValidationFeedback(ok && newStatus.isOK());
            return newStatus;
        }
    }

    static class Reference2StringConverter
    extends Converter {
        private EAttribute nameAttr;

        Reference2StringConverter(Object type, EAttribute nameAttr) {
            super(type, String.class);
            this.nameAttr = nameAttr;
        }

        public Object convert(Object fromObject) {
            return ((EObject)fromObject).eGet((EStructuralFeature)this.nameAttr);
        }
    }

    static class String2EnumConverter
    extends Converter {
        private List<? extends Enumerator> choices;

        String2EnumConverter(Object type, List<? extends Enumerator> choices) {
            super(String.class, type);
            this.choices = choices;
        }

        public Object convert(Object fromObject) {
            for (Enumerator enumerator : this.choices) {
                if (!enumerator.getLiteral().equals(fromObject)) continue;
                return enumerator;
            }
            return null;
        }
    }

    static class String2ReferenceConverter
    extends Converter {
        private List<? extends EObject> candidates;
        private EAttribute nameAttr;

        String2ReferenceConverter(Object type, List<? extends EObject> candidates, EAttribute nameAttr) {
            super(String.class, type);
            this.candidates = candidates;
            this.nameAttr = nameAttr;
        }

        public Object convert(Object fromObject) {
            for (EObject eObject : this.candidates) {
                if (!eObject.eGet((EStructuralFeature)this.nameAttr).equals(fromObject)) continue;
                return eObject;
            }
            return null;
        }
    }
}

