/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.launch;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.generator.base.AbstractGeneratorOptions;
import org.eclipse.etrice.generator.base.GeneratorApplication;
import org.eclipse.etrice.generator.base.GeneratorException;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.args.Option;
import org.eclipse.etrice.generator.base.io.ILineOutput;
import org.eclipse.etrice.generator.base.logging.Loglevel;
import org.eclipse.etrice.generator.base.setup.GeneratorApplicationOptions;
import org.eclipse.etrice.generator.launch.ConsoleOutput;
import org.eclipse.etrice.generator.launch.GeneratorLaunchHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class GeneratorLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private GeneratorLaunchHelper helper = new GeneratorLaunchHelper();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(configuration.getName()) + "...", 3);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            ConsoleOutput output = this.getConsoleOutput();
            GeneratorApplication genAppl = GeneratorApplication.create((Module)this.createGeneratorModule());
            Map<IProject, List<IFile>> models = this.getFiles(configuration);
            for (Map.Entry<IProject, List<IFile>> entry : models.entrySet()) {
                boolean includeDependencies = configuration.getAttribute("GenerateDepsWithinProject", true);
                List<Resource> resources = this.helper.loadResources(entry.getKey(), entry.getValue(), includeDependencies);
                Arguments args = genAppl.createArguments();
                this.configureArguments(args, configuration, entry.getKey());
                output.println("\n*** generating project " + entry.getKey().getName() + " ***\n");
                try {
                    genAppl.run(resources, args, (ILineOutput)output);
                }
                catch (GeneratorException generatorException) {
                    break;
                }
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
        finally {
            monitor.done();
        }
        this.launchRefreshJob(configuration);
    }

    private void launchRefreshJob(final ILaunchConfiguration configuration) {
        Job job = new Job("refresh resources after code generation"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    RefreshTab.refreshResources((ILaunchConfiguration)configuration, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected ConsoleOutput getConsoleOutput() {
        final MessageConsole myConsole = this.findConsole(this.getConsoleName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = win.getActivePage();
                    String id = "org.eclipse.ui.console.ConsoleView";
                    IConsoleView view = (IConsoleView)page.showView(id);
                    view.display((IConsole)myConsole);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        MessageConsoleStream out = myConsole.newMessageStream();
        out.getConsole().clearConsole();
        return new ConsoleOutput(out);
    }

    protected Map<IProject, List<IFile>> getFiles(ILaunchConfiguration configuration) throws CoreException {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        List models = configuration.getAttribute("ModelFiles", Collections.EMPTY_LIST);
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (String model : models) {
            String substituted = variableManager.performStringSubstitution(model);
            IFile file = root.getFileForLocation((IPath)new Path(substituted));
            if (file == null || !file.exists()) {
                throw new CoreException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Failed to find file in workspace: " + substituted));
            }
            files.add(file);
        }
        return files.stream().collect(Collectors.groupingBy(IResource::getProject));
    }

    protected void configureArguments(Arguments args, ILaunchConfiguration configuration, IProject project) throws CoreException {
        String projectDir = String.valueOf(project.getLocation().toString()) + "/";
        boolean lib = configuration.getAttribute("Lib", false);
        args.set((Option)AbstractGeneratorOptions.LIB, (Object)lib);
        if (configuration.getAttribute("SaveGenModel", false)) {
            String genModelPath = configuration.getAttribute("GenModelPath", "?");
            args.set((Option)AbstractGeneratorOptions.SAVE_GEN_MODEL, (Object)(String.valueOf(projectDir) + genModelPath));
        }
        String mainName = configuration.getAttribute("MainMethodName", (String)AbstractGeneratorOptions.MAIN_NAME.getDefaultValue());
        args.set((Option)AbstractGeneratorOptions.MAIN_NAME, (Object)mainName);
        if (configuration.getAttribute("Debug", false)) {
            args.set((Option)GeneratorApplicationOptions.LOGLEVEL, (Object)Loglevel.DEBUG);
        }
        boolean mscInstr = configuration.getAttribute("MSC", false);
        args.set((Option)AbstractGeneratorOptions.MSC_INSTR, (Object)mscInstr);
        boolean verbose = configuration.getAttribute("Verbose", false);
        args.set((Option)AbstractGeneratorOptions.VERBOSE_RT, (Object)verbose);
        boolean notranslate = !configuration.getAttribute("UseTranslation", true);
        args.set((Option)AbstractGeneratorOptions.NOTRANSLATE, (Object)notranslate);
        boolean oldStyleTransitionData = configuration.getAttribute("OldStyleTransitionData", false);
        args.set((Option)AbstractGeneratorOptions.OLD_STYLE_TRANSITION_DATA, (Object)oldStyleTransitionData);
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.generator.ui");
        boolean override = configuration.getAttribute("OverrideDirectories", false);
        String srcgenDir = prefStore.getString(this.getSrcgenDirPreferenceConstantName());
        if (override) {
            srcgenDir = configuration.getAttribute("SrcgenPath", srcgenDir);
        }
        args.set((Option)GeneratorApplicationOptions.GEN_DIR, (Object)(String.valueOf(projectDir) + srcgenDir));
        args.set((Option)GeneratorApplicationOptions.CLEAN, (Object)true);
    }

    protected String getSrcgenDirPreferenceConstantName() {
        return "GenerationDirectory";
    }

    protected abstract Module createGeneratorModule();

    protected abstract String getConsoleName();

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }
}

