/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class StringOption
extends Option<String> {
    protected final String defaultValue;
    protected final boolean emptyAsNull;
    protected final String optDialogDescr;
    protected final String optDialogLabelText;

    public StringOption(String name, String description, Character cmdShort, String cmdLong, String cmdValue, String defaultValue, boolean emptyAsNull, boolean showInDialog, String optDialogDescr, String optDialogLabelText) {
        super(name, description, cmdShort, cmdLong, cmdValue, showInDialog);
        Assert.check((!cmdLong.equals("*") ? 1 : 0) != 0);
        Assert.check((cmdValue != null ? 1 : 0) != 0);
        Assert.ifAndOnlyIf((boolean)showInDialog, (optDialogDescr != null ? 1 : 0) != 0);
        Assert.implies((!showInDialog ? 1 : 0) != 0, (optDialogLabelText == null ? 1 : 0) != 0);
        if (optDialogLabelText != null) {
            Assert.check((boolean)optDialogLabelText.endsWith(":"));
        }
        this.defaultValue = defaultValue;
        this.emptyAsNull = emptyAsNull;
        this.optDialogDescr = optDialogDescr;
        this.optDialogLabelText = optDialogLabelText;
    }

    @Override
    public String getDefault() {
        return this.defaultValue;
    }

    @Override
    public String parseValue(String optName, String value) {
        if (value == null && !this.emptyAsNull) {
            return "";
        }
        if (value != null && value.isEmpty() && this.emptyAsNull) {
            return null;
        }
        return value;
    }

    @Override
    public String[] getCmdLine(Object value) {
        String v = (String)value;
        String s = v == null ? "" : v;
        return new String[]{"--" + this.cmdLong + "=" + s};
    }

    @Override
    public OptionGroup<String> createOptionGroup(Composite page) {
        Assert.check((boolean)this.showInDialog);
        return new OptionGroup<String>(page, (Option)this){
            Label valueLabel;
            Text valueText;

            @Override
            protected void addComponents(Group group) {
                this.valueText = new Text((Composite)group, 2052);
                if (StringOption.this.optDialogLabelText == null) {
                    this.layoutGeneric(new Object[]{this.valueText});
                } else {
                    this.valueLabel = new Label((Composite)group, 0);
                    this.valueLabel.setText(StringOption.this.optDialogLabelText);
                    this.layoutGeneric(new Object[]{new Control[]{this.valueLabel, this.valueText}}, 0);
                }
            }

            @Override
            public String getDescription() {
                return StringOption.this.optDialogDescr;
            }

            @Override
            public void setToValue(String value) {
                this.valueText.setText(value == null ? "" : value);
            }

            @Override
            public String[] getCmdLine() {
                String arg = this.valueText.getText();
                return new String[]{"--" + StringOption.this.cmdLong + "=" + arg};
            }
        };
    }
}

