/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Map;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CompOnlyVarValueMarkerPredsCheck
extends CifCheck {
    private Map<DiscVariable, Expression> markeds = Maps.map();

    protected void preprocessComplexComponent(ComplexComponent comp, CifCheckViolations violations) {
        for (Expression marked : comp.getMarkeds()) {
            if (!(marked instanceof BinaryExpression)) {
                violations.add((PositionObject)marked, "Component has a marker predicate that is not of the form 'discrete_variable = marked_value'", new Object[0]);
                continue;
            }
            BinaryExpression bexpr = (BinaryExpression)marked;
            if (bexpr.getOperator() != BinaryOperator.EQUAL || !(bexpr.getLeft() instanceof DiscVariableExpression)) {
                violations.add((PositionObject)marked, "Component has a marker predicate that is not of the form 'discrete_variable = marked_value'", new Object[0]);
                continue;
            }
            DiscVariableExpression vref = (DiscVariableExpression)bexpr.getLeft();
            DiscVariable var = vref.getVariable();
            Expression newValue = bexpr.getRight();
            Expression previousValue = this.markeds.get(var);
            if (previousValue == null) {
                this.markeds.put(var, newValue);
                continue;
            }
            violations.add((PositionObject)var, "Discrete variable has multiple predicates that specify its marked value(s)", new Object[0]);
        }
    }
}

