/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng;

import javafx.scene.paint.Color;
import org.eclipse.fx.ui.controls.styledtext_ng.TextStyle;

public class StyleRange
extends TextStyle
implements Cloneable {
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public int start;
    public int length;
    public int fontStyle = 0;

    public StyleRange(String stylename) {
        super(stylename);
    }

    public StyleRange(TextStyle style) {
        super(style);
    }

    public StyleRange(String stylename, int start, int length, Color foreground, Color background) {
        super(stylename, null, foreground, background);
        this.start = start;
        this.length = length;
    }

    public StyleRange(String stylename, int start, int length, Color foreground, Color background, int fontStyle) {
        this(stylename, start, length, foreground, background);
        this.fontStyle = fontStyle;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StyleRange) {
            StyleRange style = (StyleRange)object;
            if (this.start != style.start) {
                return false;
            }
            if (this.length != style.length) {
                return false;
            }
            return this.similarTo(style);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fontStyle;
    }

    boolean isVariableHeight() {
        return this.font != null || this.rise != 0;
    }

    public boolean isUnstyled() {
        if (this.font != null) {
            return false;
        }
        if (this.rise != 0) {
            return false;
        }
        if (this.stylename != null) {
            return false;
        }
        if (this.foreground != null) {
            return false;
        }
        if (this.background != null) {
            return false;
        }
        if (this.fontStyle != 0) {
            return false;
        }
        if (this.underline) {
            return false;
        }
        if (this.strikeout) {
            return false;
        }
        return this.borderStyle == 0;
    }

    public boolean similarTo(StyleRange style) {
        if (!super.equals(style)) {
            return false;
        }
        return this.fontStyle == style.fontStyle;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("StyleRange {");
        buffer.append(this.start);
        buffer.append(", ");
        buffer.append(this.length);
        buffer.append(", fontStyle=");
        switch (this.fontStyle) {
            case 1: {
                buffer.append("bold");
                break;
            }
            case 2: {
                buffer.append("italic");
                break;
            }
            case 3: {
                buffer.append("bold-italic");
                break;
            }
            default: {
                buffer.append("normal");
            }
        }
        String str = super.toString();
        int index = str.indexOf(123);
        str = str.substring(index + 1);
        if (str.length() > 1) {
            buffer.append(", ");
        }
        buffer.append(str);
        return buffer.toString();
    }
}

