/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edapt.history.recorder.GeneratorBase;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.spi.history.Add;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.HistoryPlugin;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.history.ValueChange;

public class ChangeRecorder
extends GeneratorBase {
    private final List<? extends EObject> elements;
    private Map<EObject, List<PrimitiveChange>> deleteCache;
    private final EContentAdapter adapter;
    private boolean recording;
    private boolean consolidated;

    public ChangeRecorder(List<? extends EObject> elements) {
        this.elements = elements;
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                switch (notification.getEventType()) {
                    case 1: {
                        ChangeRecorder.this.handleSet(notification);
                        break;
                    }
                    case 3: {
                        ChangeRecorder.this.handleAdd(notification);
                        break;
                    }
                    case 5: {
                        ChangeRecorder.this.handleAddMany(notification);
                        break;
                    }
                    case 4: {
                        ChangeRecorder.this.handleRemove(notification);
                        break;
                    }
                    case 6: {
                        ChangeRecorder.this.handleRemoveMany(notification);
                        break;
                    }
                    case 7: {
                        ChangeRecorder.this.handleMove(notification);
                    }
                }
                super.notifyChanged(notification);
            }
        };
        this.beginRecording();
    }

    public void beginRecording() {
        if (!this.isRecording()) {
            this.doBeginRecording();
        } else {
            LoggingUtils.logInfo((Plugin)HistoryPlugin.getPlugin(), (String)"ChangeRecorder is already started");
        }
    }

    protected void doBeginRecording() {
        this.changeContainer = HistoryFactory.eINSTANCE.createCompositeChange();
        this.deleteCache = new IdentityHashMap<EObject, List<PrimitiveChange>>();
        for (EObject eObject : this.elements) {
            eObject.eAdapters().add((Object)this.adapter);
        }
        this.recording = true;
        this.consolidated = false;
    }

    public void endRecording() {
        if (!this.isRecording()) {
            throw new IllegalStateException("Recorder is already stopped");
        }
        this.doEndRecording();
    }

    public CompositeChange getChanges() {
        if (!this.consolidated) {
            this.inferDeletes();
            this.inferCreateInitializers();
            this.consolidated = true;
        }
        return this.changeContainer;
    }

    protected void doEndRecording() {
        for (EObject eObject : this.elements) {
            eObject.eAdapters().remove((Object)this.adapter);
        }
        this.recording = false;
    }

    public boolean isRecording() {
        return this.recording;
    }

    private void inferDeletes() {
        for (Map.Entry<EObject, List<PrimitiveChange>> entry : this.deleteCache.entrySet()) {
            List<PrimitiveChange> list = entry.getValue();
            Delete delete = (Delete)list.remove(0);
            delete.setElement(entry.getKey());
            delete.getChanges().addAll(list);
        }
    }

    private void inferCreateInitializers() {
        Create create = null;
        for (PrimitiveChange change : new ArrayList<PrimitiveChange>((Collection<PrimitiveChange>)this.changeContainer.getChanges())) {
            if (change instanceof Create) {
                create = (Create)change;
                continue;
            }
            if (change instanceof ValueChange) {
                if (create == null) continue;
                ValueChange valueChange = (ValueChange)change;
                if (create.getElement() == valueChange.getElement()) {
                    create.getChanges().add((Object)valueChange);
                    continue;
                }
                create = null;
                continue;
            }
            create = null;
        }
    }

    private void handleMove(Notification notification) {
    }

    private void handleRemoveMany(Notification notification) {
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (this.skipFeature(feature)) {
            return;
        }
        EObject element = (EObject)notification.getNotifier();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            for (EObject oldValue : (List)notification.getOldValue()) {
                this.handleSingleDelete(element, (EReference)feature, oldValue);
            }
        } else {
            for (Object oldValue : (List)notification.getOldValue()) {
                this.handleSingleRemove(element, feature, oldValue);
            }
        }
    }

    private void handleRemove(Notification notification) {
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (this.skipFeature(feature)) {
            return;
        }
        EObject element = (EObject)notification.getNotifier();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            EObject oldValue = (EObject)notification.getOldValue();
            this.handleSingleDelete(element, (EReference)feature, oldValue);
        } else {
            Object oldValue = notification.getOldValue();
            this.handleSingleRemove(element, feature, oldValue);
        }
    }

    private void handleSingleDelete(EObject element, EReference reference, EObject value) {
        Delete delete = this.delete(null, reference, element);
        this.append(delete);
        ArrayList<Delete> list = new ArrayList<Delete>();
        list.add(delete);
        this.deleteCache.put(value, list);
    }

    private void handleSingleRemove(EObject element, EStructuralFeature feature, Object value) {
        EObject deleted;
        Remove remove = this.remove(element, feature, value);
        this.append(remove);
        if (feature instanceof EReference && (deleted = this.getDeleted((EObject)value)) != null) {
            this.deleteCache.get(deleted).add(remove);
        }
    }

    private void handleAddMany(Notification notification) {
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (this.skipFeature(feature)) {
            return;
        }
        EObject element = (EObject)notification.getNotifier();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            for (EObject value : (List)notification.getNewValue()) {
                this.handleSingleCreate(feature, element, value);
            }
        } else {
            for (Object value : (List)notification.getNewValue()) {
                this.handleSingleAdd(feature, element, value);
            }
        }
    }

    private void handleAdd(Notification notification) {
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (this.skipFeature(feature)) {
            return;
        }
        EObject element = (EObject)notification.getNotifier();
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            EObject newValue = (EObject)notification.getNewValue();
            this.handleSingleCreate(feature, element, newValue);
        } else {
            Object newValue = notification.getNewValue();
            this.handleSingleAdd(feature, element, newValue);
        }
    }

    private void handleSingleAdd(EStructuralFeature feature, EObject element, Object value) {
        Add add = this.add(element, feature, value);
        this.append(add);
    }

    private void handleSingleCreate(EStructuralFeature feature, EObject element, EObject value) {
        if (this.deleteCache.containsKey(value)) {
            Delete delete = (Delete)this.deleteCache.remove(value).get(0);
            Move move = this.move(value, delete.getTarget(), (EReference)feature, element);
            this.replace(delete, move);
        } else {
            this.generateElements(Collections.singletonList(value));
        }
    }

    private void handleSet(Notification notification) {
        EObject oldValue;
        EObject deleted;
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (this.skipFeature(feature)) {
            return;
        }
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            return;
        }
        if (notification.getOldValue() == notification.getNewValue()) {
            return;
        }
        EObject element = (EObject)notification.getNotifier();
        Object newValue = notification.getNewValue();
        Set set = this.set(element, notification.getOldValue(), feature, newValue);
        this.append(set);
        if (feature instanceof EReference && (deleted = this.getDeleted(oldValue = (EObject)notification.getOldValue())) != null) {
            this.deleteCache.get(deleted).add(set);
        }
    }

    protected void replace(PrimitiveChange toReplace, PrimitiveChange replaceBy) {
        EList<PrimitiveChange> changes = this.changeContainer.getChanges();
        int index = changes.indexOf(toReplace);
        changes.set(index, replaceBy);
    }

    private EObject getDeleted(EObject element) {
        while (element != null) {
            if (this.deleteCache.containsKey(element)) {
                return element;
            }
            element = element.eContainer();
        }
        return null;
    }

    public List<? extends EObject> getElements() {
        return this.elements;
    }
}

