/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.model;

import java.util.Collection;
import java.util.List;
import org.eclipse.ease.helpgenerator.model.Description;
import org.eclipse.ease.helpgenerator.model.Field;
import org.eclipse.ease.helpgenerator.model.Method;

public abstract class AbstractClassModel {
    private String fClassName;
    private Description fClassDocumentation;
    private List<Field> fExportedFields;
    private List<Method> fExportedMethods;
    private Collection<String> fImportedClasses;
    private String fDeprecationMessage = null;

    public String getClassName() {
        return this.fClassName;
    }

    public Description getClassDocumentation() {
        return this.fClassDocumentation;
    }

    public List<Field> getExportedFields() {
        return this.fExportedFields;
    }

    public List<Method> getExportedMethods() {
        return this.fExportedMethods;
    }

    public Collection<String> getImportedClasses() {
        return this.fImportedClasses;
    }

    public String getDeprecationMessage() {
        return this.fDeprecationMessage;
    }

    public boolean isDeprecated() {
        return this.fDeprecationMessage != null;
    }

    protected void setClassName(String className) {
        this.fClassName = className;
    }

    protected void setClassDocumentation(Description classDocumentation) {
        this.fClassDocumentation = classDocumentation;
    }

    protected void setExportedFields(List<Field> exportedFields) {
        this.fExportedFields = exportedFields;
        this.fExportedFields.sort((a, b) -> a.getName().compareTo(b.getName()));
    }

    protected void setExportedMethods(List<Method> exportedMethods) {
        this.fExportedMethods = exportedMethods;
        this.fExportedMethods.sort((a, b) -> a.getName().compareTo(b.getName()));
    }

    public void setImportedClasses(Collection<String> importedClasses) {
        this.fImportedClasses = importedClasses;
    }

    public void setDeprecationMessage(String deprecationMessage) {
        this.fDeprecationMessage = deprecationMessage;
    }

    public abstract void populateModel();
}

