/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseCharIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

@Immutable
final class ImmutableCharArrayList
implements ImmutableCharList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char[] items;

    private ImmutableCharArrayList(char[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use CharLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableCharArrayList newList(CharIterable iterable) {
        return new ImmutableCharArrayList(iterable.toArray());
    }

    public static ImmutableCharArrayList newListWith(char ... elements) {
        char[] newArray = new char[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableCharArrayList(newArray);
    }

    @Override
    public char get(int index) {
        return this.items[index];
    }

    @Override
    public char getFirst() {
        return this.items[0];
    }

    @Override
    public char getLast() {
        return this.items[this.items.length - 1];
    }

    @Override
    public int indexOf(char value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(char value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public CharIterator charIterator() {
        return new InternalCharIterator();
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        for (char item : this.items) {
            procedure.value(item);
        }
    }

    @Override
    public void forEachWithIndex(CharIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    @Override
    public int count(CharPredicate predicate) {
        int count = 0;
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        for (char item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    @Override
    public ImmutableCharList select(CharPredicate predicate) {
        return this.select(predicate, new CharArrayList()).toImmutable();
    }

    @Override
    public <R extends MutableCharCollection> R select(CharPredicate predicate, R target) {
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public ImmutableCharList reject(CharPredicate predicate) {
        return this.reject(predicate, new CharArrayList()).toImmutable();
    }

    @Override
    public <R extends MutableCharCollection> R reject(CharPredicate predicate, R target) {
        for (char item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        for (char item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    @Override
    public <V> ImmutableList<V> collect(CharToObjectFunction<? extends V> function) {
        FastList list = this.collect(function, FastList.newList(this.items.length));
        return list.toImmutable();
    }

    @Override
    public <V, R extends Collection<V>> R collect(CharToObjectFunction<? extends V> function, R target) {
        for (char item : this.items) {
            target.add(function.valueOf(item));
        }
        return target;
    }

    @Override
    public long sum() {
        long result = 0L;
        for (char item : this.items) {
            result += (long)item;
        }
        return result;
    }

    @Override
    public char max() {
        char max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            char value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.max();
    }

    @Override
    public char min() {
        char min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            char value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.min();
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    @Override
    public double median() {
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    @Override
    public char[] toSortedArray() {
        char[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public long dotProduct(CharList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    @Override
    public LazyCharIterable asReversed() {
        return ReverseCharIterable.adapt(this);
    }

    @Override
    public MutableCharList toSortedList() {
        return CharArrayList.newList(this).sortThis();
    }

    @Override
    public int binarySearch(char value) {
        return Arrays.binarySearch(this.items, value);
    }

    @Override
    public char[] toArray() {
        char[] newItems = new char[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    @Override
    public boolean contains(char value) {
        for (char item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableCharList toList() {
        return CharArrayList.newList(this);
    }

    @Override
    public MutableCharSet toSet() {
        return CharHashSet.newSet(this);
    }

    @Override
    public MutableCharBag toBag() {
        return CharHashBag.newBag(this);
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public ImmutableCharList toImmutable() {
        return this;
    }

    @Override
    public ImmutableCharArrayList toReversed() {
        return ImmutableCharArrayList.newList(this.asReversed());
    }

    @Override
    public ImmutableCharList newWith(char element) {
        char[] newItems = new char[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableCharArrayList(newItems);
    }

    @Override
    public ImmutableCharList newWithout(char element) {
        int index = this.indexOf(element);
        if (index != -1) {
            char[] newItems = new char[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return CharLists.immutable.with(newItems);
        }
        return this;
    }

    @Override
    public ImmutableCharList newWithAll(CharIterable elements) {
        char[] newItems = new char[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        CharIterator iterator = elements.charIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableCharArrayList(newItems);
    }

    @Override
    public ImmutableCharList newWithoutAll(CharIterable elements) {
        MutableCharList mutableCharList = this.toList();
        mutableCharList.removeAll(elements);
        return mutableCharList.toImmutable();
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof CharList)) {
            return false;
        }
        CharList list = (CharList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (char item : this.items) {
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    @Override
    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                char value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableCharList distinct() {
        CharArrayList target = new CharArrayList();
        CharHashSet seenSoFar = new CharHashSet(this.size());
        for (char each : this.items) {
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target.toImmutable();
    }

    @Override
    public ImmutableCharList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalCharIterator
    implements CharIterator {
        private int currentIndex;

        private InternalCharIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != ImmutableCharArrayList.this.items.length;
        }

        @Override
        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            char next = ImmutableCharArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

