/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.TapIterator;
import org.eclipse.collections.impl.utility.Iterate;

@Immutable
public class TapIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;
    private final Procedure<? super T> procedure;

    public TapIterable(Iterable<T> newAdapted, Procedure<? super T> procedure) {
        this.adapted = newAdapted;
        this.procedure = procedure;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, each -> {
            this.procedure.value(each);
            procedure.value(each);
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, (each, index) -> {
            this.procedure.value(each);
            objectIntProcedure.value(each, index);
        });
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, (each, aParameter) -> {
            this.procedure.value(each);
            procedure.value((T)each, (Object)aParameter);
        }, parameter);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public T getFirst() {
        return (T)Iterate.detect(this.adapted, each -> {
            this.procedure.value(each);
            return true;
        });
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return (T)Iterate.detect(this.adapted, each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        return Iterate.detectOptional(this.adapted, each -> {
            this.procedure.value(each);
            return predicate.accept(each);
        });
    }

    @Override
    public Iterator<T> iterator() {
        return new TapIterator<T>(this.adapted, this.procedure);
    }
}

