/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.test;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.xmlpivot.common.CapellaDerivedFeatureMetadata;
import org.polarsys.capella.xmlpivot.common.predicates.EMFPredicates;

public class XMLPivotTestUtil {
    private final URI inputResourceURI;
    private final Collection<? extends EObject> inputElements;
    private final Collection<? extends EObject> importResult;

    public XMLPivotTestUtil(URI inputResourceURI, Collection<? extends EObject> inputElements, Collection<? extends EObject> importResult) {
        this.inputElements = inputElements;
        this.importResult = importResult;
        this.inputResourceURI = inputResourceURI;
    }

    public void assertAllLinksRecreated(EClass associationClass) {
        CapellaDerivedFeatureMetadata metaData = CapellaDerivedFeatureMetadata.INSTANCE;
        EReference left = metaData.getLeft(associationClass);
        EReference right = metaData.getRight(associationClass);
        ArrayList<EObject> missing = new ArrayList<EObject>();
        TreeIterator allFixtureContents = EcoreUtil.getAllContents(this.inputElements);
        UnmodifiableIterator originFrs = Iterators.filter((Iterator)allFixtureContents, (Predicate)EMFPredicates.hasEClass((EClass)associationClass));
        int tests = 0;
        block0: while (originFrs.hasNext()) {
            ++tests;
            EObject original = (EObject)originFrs.next();
            UnmodifiableIterator importedFrs = Iterators.filter((Iterator)EcoreUtil.getAllContents(this.importResult), original.getClass());
            while (importedFrs.hasNext()) {
                if (new AbstractLinkEqualityHelper(associationClass, left, right).equals(original, (EObject)importedFrs.next())) continue block0;
            }
            missing.add(original);
        }
        Assert.assertEquals((long)0L, (long)missing.size());
        if (tests == 0) {
            Assert.fail((String)("Found no links of type " + associationClass.getName() + " in test fixture" + this.inputResourceURI));
        }
    }

    public EObject getSourceElementByName(String name) {
        return this.getElementByName(name, this.inputElements);
    }

    public <T extends EObject> T getSourceElementByName(String name, Class<T> type) {
        return this.getElementByName(name, this.inputElements, type);
    }

    public EObject getImportElementById(String id) {
        return this.getElementById(id, this.importResult);
    }

    public EObject getSourceElementById(String id) {
        return this.getElementById(id, this.inputElements);
    }

    public EObject getImportElementByName(String name) {
        return this.getElementByName(name, this.importResult);
    }

    public <T extends EObject> T getImportElementByName(String name, Class<T> type) {
        return this.getElementByName(name, this.importResult, type);
    }

    private EObject getElementByName(String name, Collection<? extends EObject> scope) {
        return this.getElementByName(name, scope, EObject.class);
    }

    private EObject getElementById(String id, Collection<? extends EObject> scope) {
        TreeIterator it = EcoreUtil.getAllContents(scope);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!id.equals(EcoreUtil.getID((EObject)next))) continue;
            return next;
        }
        throw new NoSuchElementException("No element with id " + id + " found");
    }

    private <T extends EObject> T getElementByName(String name, Collection<? extends EObject> scope, Class<T> type) {
        TreeIterator it = EcoreUtil.getAllContents(scope);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof NamedElement) || !name.equals(((NamedElement)next).getName()) || !type.isInstance(next)) continue;
            return (T)next;
        }
        throw new NoSuchElementException("No NamedElement with name: " + name + " was found");
    }

    static class AbstractLinkEqualityHelper
    extends EcoreUtil.EqualityHelper {
        private final EClass linkClass;
        private final EReference source;
        private final EReference target;

        public AbstractLinkEqualityHelper(EClass linkClass_p, EReference sourceRef_p, EReference targetRef_p) {
            this.linkClass = linkClass_p;
            this.source = sourceRef_p;
            this.target = targetRef_p;
        }

        protected boolean haveEqualAttribute(EObject eObject1_p, EObject eObject2_p, EAttribute attribute_p) {
            if (this.linkClass.isInstance((Object)eObject1_p)) {
                return true;
            }
            if (attribute_p.isID()) {
                return super.haveEqualAttribute(eObject1_p, eObject2_p, attribute_p);
            }
            return true;
        }

        protected boolean haveEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature feature) {
            if (feature == this.source || feature == this.target || feature == ModellingcorePackage.Literals.MODEL_ELEMENT__ID) {
                return super.haveEqualFeature(eObject1, eObject2, feature);
            }
            return true;
        }
    }
}

