/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.exporter;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.XMLPivotPreferences;
import org.polarsys.capella.xmlpivot.XMLPivotResourceFactory;
import org.polarsys.capella.xmlpivot.exporter.AbstractExporter;
import org.polarsys.capella.xmlpivot.exporter.AbstractIncrementalExporter;
import org.polarsys.capella.xmlpivot.exporter.DefaultIncrementor;
import org.polarsys.capella.xmlpivot.exporter.ExportEngine;
import org.polarsys.capella.xmlpivot.exporter.ExporterFactory;
import org.polarsys.capella.xmlpivot.extraction.BasicConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.MemoizingConceptualMapping;

public final class XMLPivotExport {
    public static final String DEFAULT_EXPORT_COMMAND = "org.polarsys.capella.xmlpivot.ui.commands.DefaultExport";
    private final boolean dynamic;
    private final Collection<? extends EObject> selection;
    private final URI destination;
    private final ResourceSet resourceSet;
    private final AbstractExporter exporter;

    public XMLPivotExport(Collection<? extends EObject> selection_p, URI destination_p) {
        this(selection_p, destination_p, DEFAULT_EXPORT_COMMAND, true);
    }

    public XMLPivotExport(Collection<? extends EObject> selection_p, URI destination_p, String commandId_p, boolean dynamic_p) {
        this.dynamic = dynamic_p;
        this.selection = selection_p;
        this.resourceSet = new ResourceSetImpl();
        this.destination = destination_p;
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLPivotResourceFactory());
        Object mapping = null;
        mapping = this.dynamic ? XMLPivotActivator.getDefault().getDynamicConceptualMapping() : new MemoizingConceptualMapping((ConceptualMapping)new BasicConceptualMapping(EPackage.Registry.INSTANCE));
        ExportEngine engine = new ExportEngine((ConceptualMapping)mapping);
        this.exporter = this.createExporter(engine, commandId_p);
    }

    public void run(IProgressMonitor monitor_p) throws IOException, CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor_p, (String)"Pivot XML Export", (int)120);
            Collection<EObject> exporterResult = this.exporter.export(this.selection, (IProgressMonitor)progress.newChild(100));
            Resource modelResource = this.resourceSet.createResource(this.destination);
            modelResource.getContents().addAll(exporterResult);
            if (this.dynamic) {
                SubMonitor dynamicProgress = progress.newChild(10);
                Set dynamicPackages = XMLPivotActivator.getDefault().getDynamicPackageRegistry().keySet();
                dynamicProgress.setWorkRemaining(20 * dynamicPackages.size());
                NullProgressMonitor nullm = new NullProgressMonitor();
                for (String nsURI : dynamicPackages) {
                    EPackage dynamicPackage = XMLPivotActivator.getDefault().getDynamicPackageRegistry().getEPackage(nsURI);
                    if (dynamicPackage != EcorePackage.eINSTANCE) {
                        Path path = new Path(dynamicPackage.eResource().getURI().toPlatformString(true));
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                        if (!project.exists()) {
                            project.create((IProgressMonitor)nullm);
                        }
                        if (!project.isOpen()) {
                            project.open((IProgressMonitor)nullm);
                        }
                        dynamicPackage.eResource().save(Collections.EMPTY_MAP);
                    }
                    dynamicProgress.worked(10);
                }
            } else {
                progress.setWorkRemaining(10);
            }
            modelResource.save(Collections.singletonMap("SCHEMA_LOCATION", Boolean.TRUE));
            progress.worked(10);
        }
        finally {
            if (monitor_p != null) {
                monitor_p.done();
            }
        }
    }

    public Collection<? extends EObject> getSkippedElements() {
        return this.exporter.getExportEngine().getSkippedElements(this.selection);
    }

    private AbstractExporter createExporter(ExportEngine engine, String commandId) {
        AbstractExporter result = null;
        if (commandId.equals(DEFAULT_EXPORT_COMMAND)) {
            DefaultIncrementor incrementor = new DefaultIncrementor(this.selection);
            result = new AbstractIncrementalExporter(engine, incrementor);
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown command: " + commandId);
        }
        if (Platform.getPreferencesService().getBoolean("org.polarsys.capella.xmlpivot", XMLPivotPreferences.EXPORT_ALL_ANCESTORS, false, null)) {
            ExporterFactory f = ExporterFactory.INSTANCE;
            result = f.createCommonRootExporter(result);
            result = f.createProjectExporter(result);
        }
        return result;
    }
}

