/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.xmlpivot.XMLPivotActivator;
import org.polarsys.capella.xmlpivot.common.predicates.EMFFunctions;

public enum XMLPivotStatus {
    EXPORT_COMMON_ROOT_DANGLING_SUBTREE(2, "Cannot attach '{0}' because its parent '{1}' has no simplified representation");

    private int severity;
    private String message;

    private XMLPivotStatus(int severity_p, String message_p) {
        this.message = message_p;
        this.severity = severity_p;
    }

    public static IStatus toStatus(XMLPivotStatus status, Object ... args) {
        Object[] bindings = Collections2.transform(Arrays.asList(args), (Function)EMFFunctions.LABEL_HELPER_FUNCTION).toArray();
        return new Status(status.severity, "org.polarsys.capella.xmlpivot", status.ordinal(), NLS.bind((String)status.message, (Object[])bindings), null);
    }

    public static void log(XMLPivotStatus status, Object ... args) {
        XMLPivotActivator.getDefault().getLog().log(XMLPivotStatus.toStatus(status, args));
    }
}

