/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.contributor.EditorMenuContributor;
import org.eclipse.egf.core.ui.contributor.IMenuEditorActionBarContributor;
import org.eclipse.egf.core.ui.diagnostic.EGFDiagnosticDialog;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.actions.FcoreResourcePasteAction;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.workspace.ui.actions.RedoActionWrapper;
import org.eclipse.emf.workspace.ui.actions.UndoActionWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class FcoreActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener,
IMenuEditorActionBarContributor {
    private final List<EditorMenuContributor> menuContributors = new ArrayList<EditorMenuContributor>();
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(EGFModelEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                FcoreActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                EGFModelEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(EGFModelEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return FcoreActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (FcoreActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)FcoreActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected Collection<IAction> createSiblingActions;

    public FcoreActionBarContributor() {
        super(1);
        this.menuContributors.addAll(EGFCoreUIPlugin.createEditorMenuContributors((IMenuEditorActionBarContributor)this));
        this.validateAction = new ValidateAction(){
            private Resource currentResource;

            protected Diagnostic validate(IProgressMonitor progressMonitor) {
                int selectionSize;
                if (this.selectedObjects == null || this.selectedObjects.size() == 0) {
                    return Diagnostic.OK_INSTANCE;
                }
                this.currentResource = ((EObject)this.selectedObjects.get(0)).eResource();
                int count = selectionSize = this.selectedObjects.size();
                for (EObject eObject : this.selectedObjects) {
                    TreeIterator i = eObject.eAllContents();
                    while (i.hasNext()) {
                        ++count;
                        i.next();
                    }
                }
                progressMonitor.beginTask("", count);
                AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
                Diagnostician diagnostician = this.createDiagnostician(adapterFactory, progressMonitor);
                BasicDiagnostic diagnostic = selectionSize == 1 ? diagnostician.createDefaultDiagnostic((EObject)this.selectedObjects.get(0)) : new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", (Object[])new String[]{Integer.toString(selectionSize)}), this.selectedObjects.toArray());
                Map context = diagnostician.createDefaultContext();
                IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
                if (store.getBoolean("org.eclipse.egf.core.model.validate.types")) {
                    context.put("org.eclipse.egf.core.model.validate.types", Boolean.TRUE);
                } else {
                    context.put("org.eclipse.egf.core.model.validate.types", Boolean.FALSE);
                }
                context.put("org.eclipse.egf.core.platform.bundle.class.loader.map", new HashMap());
                for (EObject eObject : this.selectedObjects) {
                    progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
                    diagnostician.validate(eObject, (DiagnosticChain)diagnostic, context);
                }
                return diagnostic;
            }

            protected void handleDiagnostic(Diagnostic diagnostic) {
                int severity = diagnostic.getSeverity();
                String title = null;
                String message = null;
                if (severity == 4 || severity == 2) {
                    title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
                    message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
                } else {
                    title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
                    message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
                }
                if (this.currentResource != null) {
                    this.eclipseResourcesUtil.deleteMarkers((Object)this.currentResource);
                }
                if (diagnostic.getSeverity() == 0) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                    return;
                }
                int result = 0;
                EGFDiagnosticDialog dialog = new EGFDiagnosticDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, diagnostic, 7);
                result = dialog.open();
                if (result != 0) {
                    return;
                }
                if (dialog.getSelection() != null && !dialog.getSelection().isEmpty()) {
                    HashMap<Resource, List> resources = new HashMap<Resource, List>();
                    for (Diagnostic innerDiagnostic : dialog.getSelection()) {
                        List data = innerDiagnostic.getData();
                        if (data.isEmpty() || !(data.get(0) instanceof EObject) || ((EObject)data.get(0)).eResource() == null) continue;
                        EObject eObject = (EObject)data.get(0);
                        List eObjects = (List)resources.get(eObject.eResource());
                        if (eObjects == null) {
                            eObjects = new UniqueEList();
                            resources.put(eObject.eResource(), eObjects);
                        }
                        eObjects.add(eObject);
                    }
                    EditorHelper.openEditorsAndSelect(resources);
                }
                if (this.currentResource != null) {
                    for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                        this.eclipseResourcesUtil.createMarkers(this.currentResource, childDiagnostic);
                    }
                }
            }
        };
        this.controlAction = new ControlAction();
    }

    public void removeEditorMenuContributors(List<EditorMenuContributor> menus) {
        if (menus == null || menus.isEmpty()) {
            return;
        }
        for (EditorMenuContributor menu : menus) {
            this.menuContributors.remove(menu);
        }
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
    }

    public void contributeToMenu(IMenuManager menuManager) {
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
        for (EditorMenuContributor vpc : this.menuContributors) {
            vpc.setActiveEditor(part);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        for (EditorMenuContributor vpc : this.menuContributors) {
            vpc.selectionChanged(event);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.insertAfter("edit", (IContributionItem)new Separator("open"));
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(EGFModelEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"), "create-child");
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(EGFModelEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"), "create-sibling");
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        for (EditorMenuContributor vpc : this.menuContributors) {
            vpc.menuAboutToShow(menuManager);
        }
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new UndoActionWrapper();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoActionWrapper();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.pasteAction = new FcoreResourcePasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
    }

    public void dispose() {
        EGFCoreUIPlugin.disposeEditorMenuContributors((IMenuEditorActionBarContributor)this);
    }
}

