/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.embeddededitor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.scenario.editor.EmbeddedEditorInstance;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.DiagramToXtextCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.HelperCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.helper.XtextEditorHelper;
import org.polarsys.capella.scenario.editor.embeddededitor.views.EmbeddedEditorView;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class RefreshAction
extends Action {
    public static final String IMG_REFRESH = "icons/refresh.gif";
    public static final String PLUGIN_ID = "org.polarsys.capella.scenario.editor.embeddededitor";

    public RefreshAction() {
        this.setToolTipText("Refresh scenario text from diagram");
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)IMG_REFRESH);
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        EmbeddedEditorView eeView = XtextEditorHelper.getActiveEmbeddedEditorView();
        Scenario scenarioDiagram = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        if (EmbeddedEditorInstanceHelper.isSelectedRepresentation()) {
            DiagramToXtextCommands.process(scenarioDiagram, eeView);
        } else {
            HelperCommands.showDialogTextualEditor("Unable to refresh", "Error on refreshing data to Textual Editor! The associated diagram is not selected!");
        }
    }
}

